/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;

public class TextUtil {
    private static final Map<String, String> MOD_NAME_TO_ID = new HashMap<String, String>();
    private static boolean modNamesInitialized = false;
    private static final String[] SYLLABLE1 = new String[]{"Kr", "Ca", "Ra", "Mrok", "Cru", "Ray", "Bre", "Zed", "Drak", "Mor", "Jag", "Mer", "Jar", "Mjol", "Zork", "Mad", "Cry", "Zur", "Creo", "Azak", "Azur", "Rei", "Cro", "Mar", "Luk", "Bar"};
    private static final String[] SYLLABLE2 = new String[]{"air", "ir", "mi", "sor", "mee", "clo", "red", "cra", "ark", "arc", "miri", "lori", "cres", "mur", "zer", "marac", "zoir", "slamar", "salmar", "urak", "tim"};
    private static final String[] SYLLABLE3 = new String[]{"d", "ed", "ark", "arc", "es", "er", "der", "tron", "med", "ure", "zur", "cred", "mur", "aeus"};
    private static Random random = new Random();

    public static void initializeModNames() {
        modNamesInitialized = true;
        for (ModInfo info : ModList.get().getMods()) {
            MOD_NAME_TO_ID.put(info.getModId(), info.getDisplayName());
        }
    }

    public static String getModNameForGameObject(@Nonnull Object object) {
        ResourceLocation key;
        if (modNamesInitialized) {
            TextUtil.initializeModNames();
        }
        if (object instanceof Item) {
            key = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)((Item)object));
        } else if (object instanceof Block) {
            key = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)((Block)object));
        } else {
            return null;
        }
        String modId = key.func_110624_b();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = MOD_NAME_TO_ID.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            MOD_NAME_TO_ID.put(lowercaseModId, modName);
        }
        return modName;
    }

    public static String formatDemonName(String name) {
        return TextFormatting.GOLD.toString() + TextFormatting.BOLD.toString() + name + TextFormatting.RESET.toString();
    }

    public static ITextComponent formatDemonName(ITextComponent name) {
        return name.func_211709_a(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.BOLD});
    }

    public static String formatLargeNumber(int number) {
        if ((double)number < Math.pow(10.0, 3.0)) {
            return number + "";
        }
        if ((double)number < Math.pow(10.0, 6.0)) {
            int rounded = Math.round((float)number / 1000.0f);
            return rounded + "K";
        }
        if ((double)number < Math.pow(10.0, 9.0)) {
            int rounded = Math.round((float)number / (float)Math.pow(10.0, 6.0));
            return rounded + "M";
        }
        if ((double)number < Math.pow(10.0, 12.0)) {
            int rounded = Math.round((float)number / (float)Math.pow(10.0, 9.0));
            return rounded + "B";
        }
        return Integer.toString(number);
    }

    public static String generateName() {
        return SYLLABLE1[random.nextInt(SYLLABLE1.length)] + SYLLABLE2[random.nextInt(SYLLABLE2.length)] + SYLLABLE3[random.nextInt(SYLLABLE3.length)];
    }
}

