/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf;

import com.anar4732.opf.OPF;
import com.anar4732.opf.TEOPF;
import com.anar4732.opf.creativecore.AlignedBox;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;

public class BlockOPF
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty ATTACHED = BlockStateProperties.field_208174_a;
    public static final BooleanProperty VISIBLE = BooleanProperty.func_177716_a((String)"visible");
    private boolean dummy;
    private boolean floor;

    public BlockOPF(boolean dummy, Boolean floor) {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(5.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_200942_a());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.EAST)).func_206870_a((IProperty)ATTACHED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(true)));
        this.setRegistryName("opf", "opf" + (floor != false ? "floor" : "") + (dummy ? "dummy" : ""));
        this.dummy = dummy;
        this.floor = floor;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!this.dummy) {
            TEOPF TE = (TEOPF)world.func_175625_s(pos);
            if (placer.func_225608_bj_()) {
                TE.onFloor = true;
                world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(false)), 2);
            }
            TE.updateBlocks();
        }
    }

    public TEOPF findMainTE(World world, BlockPos pos) {
        if (this.floor) {
            Direction direction = ((Direction)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176734_d();
            for (int y = 0; y < 32; ++y) {
                BlockPos pos2 = pos.func_177967_a(direction, y);
                if (world.func_180495_p(pos2).func_177230_c() == OPF.BLOCK_OPF_DUMMY_FLOOR) {
                    if (world.func_180495_p(pos.func_177967_a(direction, y + 1)).func_177230_c() == OPF.BLOCK_OPF_DUMMY_FLOOR) continue;
                    for (int x = 0; x < 32; ++x) {
                        BlockPos pos3 = pos2.func_177967_a(direction.func_176746_e(), x);
                        if (world.func_180495_p(pos3).func_177230_c() != OPF.BLOCK_OPF) continue;
                        return (TEOPF)world.func_175625_s(pos3);
                    }
                    continue;
                }
                if (world.func_180495_p(pos2).func_177230_c() != OPF.BLOCK_OPF) continue;
                return (TEOPF)world.func_175625_s(pos2);
            }
        } else {
            Direction direction = ((Direction)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176746_e().func_176734_d();
            for (int y = 0; y < 32; ++y) {
                BlockPos pos2 = pos.func_177979_c(y);
                if (world.func_180495_p(pos2).func_177230_c() == OPF.BLOCK_OPF_DUMMY) {
                    if (world.func_180495_p(pos2.func_177977_b()).func_177230_c() == OPF.BLOCK_OPF_DUMMY) continue;
                    for (int x = 0; x < 32; ++x) {
                        BlockPos pos3 = pos2.func_177967_a(direction, x);
                        if (world.func_180495_p(pos3).func_177230_c() != OPF.BLOCK_OPF) continue;
                        return (TEOPF)world.func_175625_s(pos3);
                    }
                    continue;
                }
                if (world.func_180495_p(pos2).func_177230_c() != OPF.BLOCK_OPF) continue;
                return (TEOPF)world.func_175625_s(pos2);
            }
        }
        return null;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!this.dummy) {
            ((TEOPF)world.func_175625_s(pos)).removeBlocks();
        } else {
            TEOPF TE = this.findMainTE(world, pos);
            if (TE != null) {
                TE.removeBlocks();
                world.func_175655_b(TE.func_174877_v(), true);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList list = Lists.newArrayList();
        if (!this.dummy) {
            list.add(new ItemStack((IItemProvider)OPF.ITEM_OPF_BLOCK));
        }
        return list;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TEOPF TE = this.findMainTE(world, pos);
        if (TE != null && player.field_71075_bZ.field_75099_e) {
            OPF.proxy.openGui(TE);
            TE.func_70296_d();
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    public boolean hasTileEntity(BlockState state) {
        return !this.dummy;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TEOPF();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TEOPF) {
            return new AlignedBox(TEOPF.getBoundingBox((TEOPF)te)).getVS();
        }
        if (this.floor) {
            return new AlignedBox(0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f).getVS();
        }
        AlignedBox cube = new AlignedBox(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        if (((Boolean)state.func_177229_b((IProperty)ATTACHED)).booleanValue()) {
            direction = direction.func_176734_d();
        }
        return BlockOPF.rotateCube(cube, direction).getVS();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, ATTACHED, VISIBLE});
    }

    public static AlignedBox rotateCube(AlignedBox cube, Direction direction) {
        return BlockOPF.rotateCube(cube, direction, new Vec3d(0.5, 0.5, 0.5));
    }

    public static AlignedBox rotateCube(AlignedBox cube, Direction direction, Vec3d center) {
        AlignedBox rotateCube = new AlignedBox(cube);
        BlockOPF.applyCubeRotation(rotateCube, direction, center);
        return rotateCube;
    }

    public static Vec3d applyVectorRotation(Vec3d vector, Direction direction) {
        double tempX = vector.field_72450_a;
        double tempY = vector.field_72448_b;
        double tempZ = vector.field_72449_c;
        double posX = tempX;
        double posY = tempY;
        double posZ = tempZ;
        switch (direction) {
            case UP: {
                posX = -tempY;
                posY = tempX;
                break;
            }
            case DOWN: {
                posX = tempY;
                posY = -tempX;
                break;
            }
            case SOUTH: {
                posX = -tempZ;
                posZ = tempX;
                break;
            }
            case NORTH: {
                posX = tempZ;
                posZ = -tempX;
                break;
            }
            case WEST: {
                posX = -tempX;
                posZ = -tempZ;
                break;
            }
        }
        return new Vec3d(posX, posY, posZ);
    }

    public static void applyCubeRotation(AlignedBox cube, Direction direction, Vec3d center) {
        float minX = cube.minX;
        float minY = cube.minY;
        float minZ = cube.minZ;
        float maxX = cube.maxX;
        float maxY = cube.maxY;
        float maxZ = cube.maxZ;
        if (center != null) {
            minX = (float)((double)minX - center.field_72450_a);
            minY = (float)((double)minY - center.field_72448_b);
            minZ = (float)((double)minZ - center.field_72449_c);
            maxX = (float)((double)maxX - center.field_72450_a);
            maxY = (float)((double)maxY - center.field_72448_b);
            maxZ = (float)((double)maxZ - center.field_72449_c);
        }
        Vec3d min = BlockOPF.applyVectorRotation(new Vec3d((double)minX, (double)minY, (double)minZ), direction);
        Vec3d max = BlockOPF.applyVectorRotation(new Vec3d((double)maxX, (double)maxY, (double)maxZ), direction);
        if (center != null) {
            min = min.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            max = max.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        }
        if (min.field_72450_a < max.field_72450_a) {
            cube.minX = (float)min.field_72450_a;
            cube.maxX = (float)max.field_72450_a;
        } else {
            cube.minX = (float)max.field_72450_a;
            cube.maxX = (float)min.field_72450_a;
        }
        if (min.field_72448_b < max.field_72448_b) {
            cube.minY = (float)min.field_72448_b;
            cube.maxY = (float)max.field_72448_b;
        } else {
            cube.minY = (float)max.field_72448_b;
            cube.maxY = (float)min.field_72448_b;
        }
        if (min.field_72449_c < max.field_72449_c) {
            cube.minZ = (float)min.field_72449_c;
            cube.maxZ = (float)max.field_72449_c;
        } else {
            cube.minZ = (float)max.field_72449_c;
            cube.maxZ = (float)min.field_72449_c;
        }
    }
}

