/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf;

import com.anar4732.opf.BlockOPF;
import com.anar4732.opf.OPF;
import com.anar4732.opf.client.DownloadingTextureExtended;
import com.anar4732.opf.creativecore.AlignedBox;
import com.google.common.hash.Hashing;
import java.io.File;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class TEOPF
extends TileEntity
implements ITickableTileEntity {
    public static final int maxSize = 32;
    public String url = "https://techcrunch.com/wp-content/uploads/2015/08/safe_image.gif";
    public int sizeX = 1;
    public int sizeY = 1;
    public boolean flippedX;
    public boolean flippedY;
    public boolean onFloor;
    public float brightness = 1.0f;
    public String oldUrl = "";
    public static final String defaultUrl = "https://techcrunch.com/wp-content/uploads/2015/08/safe_image.gif";
    @OnlyIn(value=Dist.CLIENT)
    public DownloadingTextureExtended textureWorker;
    @OnlyIn(value=Dist.CLIENT)
    public static File cacheDir;
    @OnlyIn(value=Dist.CLIENT)
    public static TextureManager textureManager;
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation textureLocation;

    public TEOPF() {
        super(OPF.TEType_OPF);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            cacheDir = new File(Minecraft.func_71410_x().field_71412_D, "opf_cache");
            textureManager = Minecraft.func_71410_x().func_110434_K();
        }
    }

    public void removeBlocks() {
        this.removeBlocks(this.sizeX, this.sizeY);
    }

    public void removeBlocks(int oldSizeX, int oldSizeY) {
        Direction direction = ((Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockOPF.FACING)).func_176746_e();
        if (!this.onFloor) {
            for (int x = 0; x < oldSizeX; ++x) {
                BlockPos pos2 = this.field_174879_c.func_177967_a(direction, x);
                if (!pos2.equals((Object)this.field_174879_c) && this.field_145850_b.func_180495_p(pos2).func_177230_c() == OPF.BLOCK_OPF_DUMMY) {
                    this.field_145850_b.func_180501_a(pos2, Blocks.field_150350_a.func_176223_P(), 3);
                }
                for (int y = 1; y < oldSizeY; ++y) {
                    BlockPos pos3 = pos2.func_177967_a(Direction.UP, y);
                    if (this.field_145850_b.func_180495_p(pos3).func_177230_c() != OPF.BLOCK_OPF_DUMMY) continue;
                    this.field_145850_b.func_180501_a(pos3, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        } else {
            for (int x = 0; x < oldSizeX; ++x) {
                BlockPos pos2 = this.field_174879_c.func_177967_a(direction.func_176746_e().func_176746_e().func_176746_e(), x);
                if (!pos2.equals((Object)this.field_174879_c) && this.field_145850_b.func_180495_p(pos2).func_177230_c() == OPF.BLOCK_OPF_DUMMY_FLOOR) {
                    this.field_145850_b.func_180501_a(pos2, Blocks.field_150350_a.func_176223_P(), 3);
                }
                for (int y = 1; y < oldSizeY; ++y) {
                    BlockPos pos3 = pos2.func_177967_a(direction, y);
                    if (this.field_145850_b.func_180495_p(pos3).func_177230_c() != OPF.BLOCK_OPF_DUMMY_FLOOR) continue;
                    this.field_145850_b.func_180501_a(pos3, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        }
    }

    public void updateBlocks() {
        this.updateBlocks(this.sizeX, this.sizeY);
    }

    public void updateBlocks(int oldSizeX, int oldSizeY) {
        this.removeBlocks(oldSizeX, oldSizeY);
        Direction direction = ((Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockOPF.FACING)).func_176746_e();
        if (this.onFloor) {
            for (int x = 0; x < this.sizeX; ++x) {
                BlockPos pos2 = this.field_174879_c.func_177967_a(direction.func_176746_e().func_176746_e().func_176746_e(), x);
                if (!pos2.equals((Object)this.field_174879_c)) {
                    if (this.field_145850_b.func_180495_p(pos2).isAir((IBlockReader)this.field_145850_b, pos2)) {
                        this.field_145850_b.func_180501_a(pos2, (BlockState)((BlockState)((BlockState)OPF.BLOCK_OPF_DUMMY_FLOOR.func_176223_P().func_206870_a((IProperty)BlockOPF.FACING, this.func_195044_w().func_177229_b((IProperty)BlockOPF.FACING))).func_206870_a((IProperty)BlockOPF.ATTACHED, this.func_195044_w().func_177229_b((IProperty)BlockOPF.ATTACHED))).func_206870_a((IProperty)BlockOPF.VISIBLE, this.func_195044_w().func_177229_b((IProperty)BlockOPF.VISIBLE)), 3);
                    } else {
                        this.sizeX = x;
                        continue;
                    }
                }
                for (int y = 1; y < this.sizeY; ++y) {
                    BlockPos pos3 = pos2.func_177967_a(direction, y);
                    if (this.field_145850_b.func_180495_p(pos3).isAir((IBlockReader)this.field_145850_b, pos3)) {
                        this.field_145850_b.func_180501_a(pos3, (BlockState)((BlockState)((BlockState)OPF.BLOCK_OPF_DUMMY_FLOOR.func_176223_P().func_206870_a((IProperty)BlockOPF.FACING, this.func_195044_w().func_177229_b((IProperty)BlockOPF.FACING))).func_206870_a((IProperty)BlockOPF.ATTACHED, this.func_195044_w().func_177229_b((IProperty)BlockOPF.ATTACHED))).func_206870_a((IProperty)BlockOPF.VISIBLE, this.func_195044_w().func_177229_b((IProperty)BlockOPF.VISIBLE)), 3);
                        continue;
                    }
                    this.sizeY = y;
                }
            }
        } else {
            for (int x = 0; x < this.sizeX; ++x) {
                BlockPos pos2 = this.field_174879_c.func_177967_a(direction, x);
                if (!pos2.equals((Object)this.field_174879_c)) {
                    if (this.field_145850_b.func_180495_p(pos2).isAir((IBlockReader)this.field_145850_b, pos2)) {
                        this.field_145850_b.func_180501_a(pos2, (BlockState)((BlockState)((BlockState)OPF.BLOCK_OPF_DUMMY.func_176223_P().func_206870_a((IProperty)BlockOPF.FACING, this.func_195044_w().func_177229_b((IProperty)BlockOPF.FACING))).func_206870_a((IProperty)BlockOPF.ATTACHED, this.func_195044_w().func_177229_b((IProperty)BlockOPF.ATTACHED))).func_206870_a((IProperty)BlockOPF.VISIBLE, this.func_195044_w().func_177229_b((IProperty)BlockOPF.VISIBLE)), 3);
                    } else {
                        this.sizeX = x;
                        continue;
                    }
                }
                for (int y = 1; y < this.sizeY; ++y) {
                    BlockPos pos3 = pos2.func_177967_a(Direction.UP, y);
                    if (this.field_145850_b.func_180495_p(pos3).isAir((IBlockReader)this.field_145850_b, pos3)) {
                        this.field_145850_b.func_180501_a(pos3, (BlockState)((BlockState)((BlockState)OPF.BLOCK_OPF_DUMMY.func_176223_P().func_206870_a((IProperty)BlockOPF.FACING, this.func_195044_w().func_177229_b((IProperty)BlockOPF.FACING))).func_206870_a((IProperty)BlockOPF.ATTACHED, this.func_195044_w().func_177229_b((IProperty)BlockOPF.ATTACHED))).func_206870_a((IProperty)BlockOPF.VISIBLE, this.func_195044_w().func_177229_b((IProperty)BlockOPF.VISIBLE)), 3);
                        continue;
                    }
                    this.sizeY = y;
                }
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("url", this.url);
        compound.func_74768_a("sizeX", this.sizeX);
        compound.func_74768_a("sizeY", this.sizeY);
        compound.func_74757_a("floor", this.onFloor);
        compound.func_74757_a("flippedX", this.flippedX);
        compound.func_74757_a("flippedY", this.flippedY);
        compound.func_74776_a("brightness", this.brightness);
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.url = compound.func_74779_i("url");
        this.sizeX = compound.func_74762_e("sizeX");
        this.sizeY = compound.func_74762_e("sizeY");
        this.onFloor = compound.func_74767_n("floor");
        this.flippedX = compound.func_74767_n("flippedX");
        this.flippedY = compound.func_74767_n("flippedY");
        this.brightness = compound.func_74764_b("brightness") ? compound.func_74760_g("brightness") : 1.0f;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket p) {
        this.func_145839_a(p.func_148857_g());
        this.checkAndUpdate();
    }

    public void checkAndUpdate() {
        if (!this.oldUrl.equals(this.url)) {
            this.loadTexture();
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K && this.textureLocation != null) {
            textureManager.func_229267_b_(this.textureLocation).func_147631_c();
            this.textureWorker = null;
        }
    }

    public static AxisAlignedBB getBoundingBox(TEOPF frame) {
        AlignedBox cube = new AlignedBox(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
        float sizeX = frame.sizeX;
        float sizeY = frame.sizeY;
        if (sizeX == 0.0f) {
            sizeX = 1.0f;
        }
        if (sizeY == 0.0f) {
            sizeY = 1.0f;
        }
        Direction direction = (Direction)frame.field_145850_b.func_180495_p(frame.field_174879_c).func_177229_b((IProperty)BlockOPF.FACING);
        cube.maxZ += sizeX - 1.0f;
        cube.maxY += sizeY - 1.0f;
        cube = new AlignedBox(Math.min(cube.minX, cube.maxX), Math.min(cube.minY, cube.maxY), Math.min(cube.minZ, cube.maxZ), Math.max(cube.minX, cube.maxX), Math.max(cube.minY, cube.maxY), Math.max(cube.minZ, cube.maxZ));
        if (frame.onFloor) {
            cube.set(-cube.maxY + 1.0f, 0.0f, -cube.maxZ + 1.0f, 1.0f, 0.05f, 1.0f);
            return BlockOPF.rotateCube(cube, direction.func_176734_d()).getBB();
        }
        if (((Boolean)frame.field_145850_b.func_180495_p(frame.field_174879_c).func_177229_b((IProperty)BlockOPF.ATTACHED)).booleanValue()) {
            cube.set(0.0f, cube.maxY, -cube.maxZ + 1.0f, 0.05f, 0.0f, 1.0f);
            return BlockOPF.rotateCube(cube, direction.func_176734_d()).getBB();
        }
        return BlockOPF.rotateCube(cube, direction).getBB();
    }

    public void func_73660_a() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldLoadTexture() {
        return !this.isTextureLoaded();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation loadTexture() {
        this.oldUrl = this.url;
        String s = Hashing.sha1().hashUnencodedChars((CharSequence)this.url).toString().replaceAll("==", "xx");
        this.textureLocation = new ResourceLocation("opf", "frames/" + s + this.func_174877_v().func_177958_n() + this.func_174877_v().func_177956_o() + this.func_174877_v().func_177952_p());
        File f = new File(cacheDir.toString(), "/" + s);
        this.textureWorker = new DownloadingTextureExtended(f, this.url, this.textureLocation, null, this);
        textureManager.func_229263_a_(this.textureLocation, (Texture)this.textureWorker);
        return this.textureLocation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTextureLoaded() {
        return this.textureWorker != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void tickTexture() {
        if (this.textureWorker != null && this.textureWorker.isGif()) {
            this.textureWorker.tick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

