/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf.client;

import com.anar4732.opf.OPF;
import com.anar4732.opf.TEOPF;
import com.google.common.hash.Hashing;
import com.madgag.gif.fmsware.GifDecoder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class DownloadingTextureExtended
extends SimpleTexture {
    private static final Logger LOGGER = OPF.LOGGER;
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private final Runnable processTask;
    @Nullable
    private CompletableFuture<?> future;
    private int frameIndex = 0;
    private int delayTimer = 0;
    private TEOPF frame = null;
    private ArrayList<byte[]> frames;
    public boolean error;
    public boolean loaded = false;

    public DownloadingTextureExtended(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, @Nullable Runnable processTaskIn, TEOPF frame) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.processTask = processTaskIn;
        this.frame = frame;
    }

    private void setImage(NativeImage nativeImageIn) {
        if (this.processTask != null) {
            this.processTask.run();
        }
        Minecraft.func_71410_x().execute(() -> {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        Minecraft.func_71410_x().execute(() -> {});
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                nativeimage = this.loadTexture(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.setImage(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    LOGGER.debug("Downloading http texture from {} to {}", (Object)this.imageUrl, (Object)this.cacheFile);
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputstream;
                            if (this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.cacheFile);
                                inputstream = new FileInputStream(this.cacheFile);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            Minecraft.func_71410_x().execute(() -> {
                                NativeImage nativeimage1 = this.loadTexture(inputstream);
                                if (nativeimage1 != null) {
                                    this.setImage(nativeimage1);
                                }
                            });
                            return;
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Couldn't download http texture", (Throwable)exception);
                        this.error = true;
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }, Util.func_215072_e());
            }
        }
    }

    @Nullable
    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            final byte[] data = IOUtils.toByteArray((InputStream)inputStreamIn);
            String type = DownloadingTextureExtended.readType(data);
            if (type.equalsIgnoreCase("gif")) {
                new Thread(){

                    @Override
                    public void run() {
                        GifDecoder gif = new GifDecoder();
                        int status = gif.read(new ByteArrayInputStream(data));
                        if (status == 0) {
                            DownloadingTextureExtended.this.frames = new ArrayList();
                            File pgcfile = new File(TEOPF.cacheDir, Hashing.sha1().hashUnencodedChars((CharSequence)((DownloadingTextureExtended)DownloadingTextureExtended.this).frame.url).toString().replaceAll("==", "xx") + ".pgc");
                            if (pgcfile.isFile()) {
                                try {
                                    LOGGER.debug("Loading PGC from local cache ({})", (Object)pgcfile.toString());
                                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(pgcfile));
                                    DownloadingTextureExtended.this.frames = (ArrayList)ois.readObject();
                                    ois.close();
                                    DownloadingTextureExtended.this.loaded = true;
                                    this.finalize();
                                    return;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                            for (int i = 0; i < gif.getFrameCount(); ++i) {
                                try {
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    ImageIO.write((RenderedImage)gif.getFrame(i), "png", baos);
                                    baos.flush();
                                    DownloadingTextureExtended.this.frames.add(baos.toByteArray());
                                    baos.close();
                                    continue;
                                }
                                catch (IOException ioexception) {
                                    LOGGER.warn("Error while loading the texture", (Throwable)ioexception);
                                    DownloadingTextureExtended.this.error = true;
                                }
                            }
                            try {
                                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(pgcfile));
                                oos.writeObject(DownloadingTextureExtended.this.frames);
                                oos.close();
                                gif = null;
                                DownloadingTextureExtended.this.loaded = true;
                                this.finalize();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        } else {
                            LOGGER.error("Failed to read gif: {}", (Object)status);
                            DownloadingTextureExtended.this.error = true;
                        }
                    }
                }.start();
            } else {
                this.loaded = true;
            }
            nativeimage = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException ioexception) {
            LOGGER.warn("Error while loading the texture", (Throwable)ioexception);
            this.error = true;
        }
        return nativeimage;
    }

    private static String readType(byte[] input) throws IOException {
        String string;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            string = DownloadingTextureExtended.readType(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readType(InputStream input) throws IOException {
        input.mark(0);
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return "";
        }
        ImageReader reader = iter.next();
        if (reader.getFormatName().equalsIgnoreCase("gif")) {
            return "gif";
        }
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            reader.read(0, param);
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse input format", (Throwable)e);
        }
        finally {
            reader.dispose();
            IOUtils.closeQuietly((Closeable)stream);
        }
        input.reset();
        return reader.getFormatName();
    }

    public boolean isGif() {
        return this.frames != null;
    }

    public void tick() {
        block6: {
            if (this.delayTimer > 0) {
                this.delayTimer = 0;
                try {
                    TEOPF.textureManager.func_229267_b_(this.field_110568_b).func_147631_c();
                    this.setImage(NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(this.frames.get(this.frameIndex))));
                    if (this.frameIndex == this.frames.size() - 1) {
                        this.frameIndex = 0;
                        break block6;
                    }
                    ++this.frameIndex;
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                    this.error = true;
                }
            } else if (this.loaded) {
                ++this.delayTimer;
            }
        }
    }
}

