/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf.creativecore;

import com.anar4732.opf.creativecore.Rotation;
import javaa.vecmath.Matrix3f;
import javaa.vecmath.Vector3d;
import javaa.vecmath.Vector3f;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;

public class AlignedBox {
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public AlignedBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public AlignedBox(AxisAlignedBB box) {
        this((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72337_e, (float)box.field_72334_f);
    }

    public AlignedBox() {
        this(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AlignedBox(AlignedBox cube) {
        this(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ);
    }

    public void add(Vector3d vec) {
        this.minX = (float)((double)this.minX + vec.x);
        this.minY = (float)((double)this.minY + vec.y);
        this.minZ = (float)((double)this.minZ + vec.z);
        this.maxX = (float)((double)this.maxX + vec.x);
        this.maxY = (float)((double)this.maxY + vec.y);
        this.maxZ = (float)((double)this.maxZ + vec.z);
    }

    public void sub(Vector3d vec) {
        this.minX = (float)((double)this.minX - vec.x);
        this.minY = (float)((double)this.minY - vec.y);
        this.minZ = (float)((double)this.minZ - vec.z);
        this.maxX = (float)((double)this.maxX - vec.x);
        this.maxY = (float)((double)this.maxY - vec.y);
        this.maxZ = (float)((double)this.maxZ - vec.z);
    }

    public void add(Vector3i vec) {
        this.minX += (float)vec.func_177958_n();
        this.minY += (float)vec.func_177956_o();
        this.minZ += (float)vec.func_177952_p();
        this.maxX += (float)vec.func_177958_n();
        this.maxY += (float)vec.func_177956_o();
        this.maxZ += (float)vec.func_177952_p();
    }

    public void sub(Vector3i vec) {
        this.minX -= (float)vec.func_177958_n();
        this.minY -= (float)vec.func_177956_o();
        this.minZ -= (float)vec.func_177952_p();
        this.maxX -= (float)vec.func_177958_n();
        this.maxY -= (float)vec.func_177956_o();
        this.maxZ -= (float)vec.func_177952_p();
    }

    public Vector3d getSize() {
        return new Vector3d(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public String toString() {
        return "cube[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public AxisAlignedBB getBB() {
        return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public VoxelShape getVS() {
        return VoxelShapes.func_197873_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public void rotate(Rotation rotation, Vector3f center) {
        Vector3f low = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f high = new Vector3f(this.maxX, this.maxY, this.maxZ);
        low.sub(center);
        high.sub(center);
        rotation.getMatrix().transform(low);
        rotation.getMatrix().transform(high);
        low.add(center);
        high.add(center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void rotate(Direction facing, Vector3f center) {
        Matrix3f matrix = new Matrix3f();
        if (facing.func_176740_k() == Direction.Axis.X) {
            facing = facing.func_176734_d();
        }
        matrix.rotY((float)Math.toRadians(facing.func_185119_l()));
        this.rotate(matrix, center);
    }

    public void rotate(Matrix3f matrix, Vector3f center) {
        Vector3f low = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f high = new Vector3f(this.maxX, this.maxY, this.maxZ);
        low.sub(center);
        high.sub(center);
        matrix.transform(low);
        matrix.transform(high);
        low.add(center);
        high.add(center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void set(float x, float y, float z, float x2, float y2, float z2) {
        this.minX = Math.min(x, x2);
        this.minY = Math.min(y, y2);
        this.minZ = Math.min(z, z2);
        this.maxX = Math.max(x, x2);
        this.maxY = Math.max(y, y2);
        this.maxZ = Math.max(z, z2);
    }

    public BlockPos getOffset() {
        return new BlockPos((double)this.minX, (double)this.minY, (double)this.minZ);
    }

    public float getValueOfFacing(Direction facing) {
        switch (facing) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public float getSize(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX - this.minX;
            }
            case Y: {
                return this.maxY - this.minY;
            }
            case Z: {
                return this.maxZ - this.minZ;
            }
        }
        return 0.0f;
    }

    public void setMin(Direction.Axis axis, float value) {
        switch (axis) {
            case X: {
                this.minX = value;
                break;
            }
            case Y: {
                this.minY = value;
                break;
            }
            case Z: {
                this.minZ = value;
            }
        }
    }

    public float getMin(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public void setMax(Direction.Axis axis, float value) {
        switch (axis) {
            case X: {
                this.maxX = value;
                break;
            }
            case Y: {
                this.maxY = value;
                break;
            }
            case Z: {
                this.maxZ = value;
            }
        }
    }

    public float getMax(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0.0f;
    }
}

