/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import com.google.common.collect.MoreCollectors;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import me.modmuss50.optifabric.patcher.StaticFuzzer;
import me.modmuss50.optifabric.util.RemappingUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.mapping.tree.FieldDef;
import org.apache.commons.lang3.Validate;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;

public class ClassCache {
    private final byte[] hash;
    private final Map<String, byte[]> classes = new HashMap<String, byte[]>();
    private boolean converted;

    public ClassCache(byte[] hash) {
        this.hash = hash;
    }

    public void addClass(String name, byte[] bytes) {
        if (this.classes.containsKey(name)) {
            throw new IllegalArgumentException(name + " is already in ClassCache");
        }
        this.classes.put(name, (byte[])Validate.notNull((Object)bytes, (String)"Passed null bytes for %s", (Object[])new Object[]{name}));
    }

    public Set<String> getClasses() {
        return this.classes.keySet();
    }

    public byte[] getClass(String name) {
        return this.classes.get(name);
    }

    public byte[] popClass(String name) {
        return this.classes.remove(name);
    }

    public byte[] getHash() {
        return this.hash;
    }

    private long calculateCRC() {
        CRC32 crc = new CRC32();
        crc.update(this.hash);
        for (byte[] clazz : this.classes.values()) {
            crc.update(clazz);
        }
        return crc.getValue();
    }

    public static ClassCache read(File input) throws IOException {
        try (DataInputStream dis = new DataInputStream(new GZIPInputStream(new FileInputStream(input)));){
            String particleManager;
            byte[] particleManagerContents;
            String name;
            boolean isFormatC;
            char formatRevision = dis.readChar();
            boolean isFormatA = formatRevision == 'A';
            boolean isFormatB = formatRevision == 'B';
            boolean bl = isFormatC = formatRevision == 'C';
            if (!(isFormatA || isFormatB || isFormatC || formatRevision == 'D')) {
                ClassCache classCache = new ClassCache(null);
                return classCache;
            }
            long expectedCRC = dis.readLong();
            byte[] hash = new byte[dis.readInt()];
            dis.readFully(hash);
            ClassCache classCache = new ClassCache(hash);
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                byte[] byArray = new byte[dis.readInt()];
                dis.readFully(byArray);
                name = new String(byArray, StandardCharsets.UTF_8);
                byte[] bytes = new byte[dis.readInt()];
                dis.readFully(bytes);
                classCache.classes.put(name, bytes);
            }
            if (classCache.calculateCRC() != expectedCRC) {
                ClassCache i = new ClassCache(null);
                return i;
            }
            if (isFormatA) {
                ArrayList<Map.Entry<String, byte[]>> classes = new ArrayList<Map.Entry<String, byte[]>>(classCache.classes.entrySet());
                classCache.classes.clear();
                for (Map.Entry entry : classes) {
                    name = (String)entry.getKey();
                    classCache.classes.put(name.substring(0, name.length() - 6), (byte[])entry.getValue());
                }
            }
            if ((isFormatA || isFormatB) && (particleManagerContents = classCache.popClass(particleManager = RemappingUtils.getClassName("class_702"))) != null) {
                final FieldDef fieldDef = (FieldDef)FabricLauncherBase.getLauncher().getMappingConfiguration().getMappings().getClasses().stream().filter(clazz -> "net/minecraft/class_702".equals(clazz.getName("intermediary"))).flatMap(clazz -> clazz.getFields().stream()).filter(field -> "field_3835".equals(field.getName("intermediary"))).collect(MoreCollectors.onlyElement());
                final String namespace = FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
                ClassReader reader = new ClassReader(particleManagerContents);
                ClassWriter writer = new ClassWriter(reader, 0);
                reader.accept(new ClassVisitor(524288, (ClassVisitor)writer){
                    private final String oldName;
                    private final String newName;
                    {
                        super(x0, x1);
                        this.oldName = fieldDef.getName("official");
                        this.newName = fieldDef.getName(namespace);
                    }

                    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                        return super.visitField(access, this.oldName.equals(name) && "Ljava/util/Map;".equals(descriptor) ? this.newName : name, descriptor, signature, value);
                    }
                }, 0);
                classCache.addClass(particleManager, writer.toByteArray());
            }
            if (isFormatA || isFormatB || isFormatC) {
                try (StaticFuzzer fuzzer = new StaticFuzzer();){
                    for (Map.Entry<String, byte[]> entry : classCache.classes.entrySet()) {
                        entry.setValue(fuzzer.apply(entry.getValue()));
                    }
                }
                classCache.converted = true;
            }
            ClassCache classCache2 = classCache;
            return classCache2;
        }
    }

    public void save(File output) throws IOException {
        if (output.exists()) {
            output.delete();
        }
        try (DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(output)));){
            dos.writeChar(68);
            dos.writeLong(this.calculateCRC());
            dos.writeInt(this.hash.length);
            dos.write(this.hash);
            dos.writeInt(this.classes.size());
            for (Map.Entry<String, byte[]> clazz : this.classes.entrySet()) {
                String name = clazz.getKey();
                byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
                byte[] bytes = clazz.getValue();
                dos.writeInt(nameBytes.length);
                dos.write(nameBytes);
                dos.writeInt(bytes.length);
                dos.write(bytes);
            }
        }
    }

    public boolean isConverted() {
        return this.converted;
    }
}

