/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    public static void iterateContents(File zip, ZipVisitor visitor) {
        try (ZipFile origin = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> it = origin.entries();
            while (it.hasMoreElements() && visitor.visit(origin, it.nextElement())) {
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error iterating " + zip, e);
        }
    }

    public static void extract(File zip, File to) {
        ZipUtils.iterateContents(zip, (zipFile, entry) -> {
            String name = entry.getName();
            File extract = new File(to, name);
            if (name.indexOf("..") >= 0 && !extract.getCanonicalPath().startsWith(to.getCanonicalPath())) {
                throw new SecurityException("The file \"" + name + "\" (in " + zip + ") tried to leave the output directory: " + to);
            }
            if (entry.isDirectory()) {
                FileUtils.forceMkdir((File)extract);
            } else {
                FileUtils.forceMkdir((File)extract.getParentFile());
                FileUtils.copyInputStreamToFile((InputStream)zipFile.getInputStream(entry), (File)extract);
            }
            return true;
        });
    }

    public static void filter(File zipOrigin, ZipVisitor filter, File zipDestination) {
        ZipUtils.transform(zipOrigin, filter, zipDestination);
    }

    public static void filterInPlace(File zip, ZipVisitor filter) {
        ZipUtils.transformInPlace(zip, filter);
    }

    public static void transform(File zipOrigin, ZipTransformer transformer, File zipDestination) {
        try {
            ZipUtils.transform(zipOrigin, 1, transformer, zipDestination);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)zipDestination);
            throw new UncheckedIOException("Error transforming " + zipOrigin, e);
        }
    }

    public static void transformInPlace(File zip, ZipTransformer transformer) {
        File tempZip = null;
        try {
            tempZip = File.createTempFile("optifabric", ".zip");
            ZipUtils.transform(zip, 5, transformer, tempZip);
            zip.delete();
            FileUtils.moveFile((File)tempZip, (File)zip);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error modifying " + zip, e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempZip);
        }
    }

    private static void transform(File zipOrigin, int originFlags, ZipTransformer transformer, File zipDestination) throws IOException {
        try (ZipFile origin = new ZipFile(zipOrigin, originFlags);
             ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipDestination)));){
            boolean pure = transformer instanceof ZipVisitor;
            Enumeration<? extends ZipEntry> it = origin.entries();
            while (it.hasMoreElements()) {
                ZipEntry entry = it.nextElement();
                InputStream in = transformer.apply(origin, entry);
                Throwable throwable = null;
                try {
                    if (in == null) continue;
                    out.putNextEntry(pure ? new ZipEntry(entry) : new ZipEntry(entry.getName()));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    public static interface ZipVisitor
    extends ZipTransformer {
        @Override
        default public InputStream apply(ZipFile zip, ZipEntry entry) throws IOException {
            return this.visit(zip, entry) ? zip.getInputStream(entry) : null;
        }

        public boolean visit(ZipFile var1, ZipEntry var2) throws IOException;
    }

    public static interface ZipTransformer {
        public InputStream apply(ZipFile var1, ZipEntry var2) throws IOException;
    }
}

