/*
 * Decompiled with CFR 0.152.
 */
package ghana7.perpetualstew.tile;

import ghana7.perpetualstew.PerpetualStewMod;
import ghana7.perpetualstew.util.FoodInfo;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class StewTubTileEntity
extends TileEntity
implements ITickableTileEntity {
    private int timerMax;
    private int timer;
    private int cookTime;
    private int waterCapacity;
    private int currentWaterAmount;
    private ItemStack[] lastTenItems;
    public int color;
    private int totalFoods;
    private int totalPoisonous;
    private int totalMeats;
    private int totalVeggies;
    private int totalSweets;
    private int totalMagic;

    public StewTubTileEntity() {
        super((TileEntityType)PerpetualStewMod.STEW_TUB_TE.get());
        this.timer = this.timerMax = 1200;
        this.cookTime = 0;
        this.waterCapacity = 4000;
        this.currentWaterAmount = 0;
        this.lastTenItems = new ItemStack[10];
        for (int i = 0; i < this.lastTenItems.length; ++i) {
            this.lastTenItems[i] = ItemStack.field_190927_a.func_77946_l();
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.timer > 0 && this.currentWaterAmount >= 1000) {
            --this.timer;
        }
        if (this.timer <= 0) {
            this.timer = this.timerMax;
            ++this.cookTime;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        int i;
        this.lastTenItems = new ItemStack[10];
        for (i = 0; i < this.lastTenItems.length; ++i) {
            this.lastTenItems[i] = ItemStack.field_190927_a.func_77946_l();
        }
        for (i = 0; i < this.lastTenItems.length; ++i) {
            this.lastTenItems[i] = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)tag.func_74781_a("item" + i)));
        }
        this.color = this.getAverageColor();
        this.timer = tag.func_74762_e("timer");
        this.currentWaterAmount = tag.func_74762_e("waterAmount");
        this.cookTime = tag.func_74762_e("cookTime");
        this.totalFoods = tag.func_74762_e("perpetualstew_totalFoods");
        this.totalPoisonous = tag.func_74762_e("perpetualstew_totalPoisonous");
        this.totalMeats = tag.func_74762_e("perpetualstew_totalMeats");
        this.totalVeggies = tag.func_74762_e("perpetualstew_totalVeggies");
        this.totalSweets = tag.func_74762_e("perpetualstew_totalSweets");
        this.totalMagic = tag.func_74762_e("perpetualstew_totalMagic");
        super.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (int i = 0; i < this.lastTenItems.length; ++i) {
            tag.func_218657_a("item" + i, (INBT)this.lastTenItems[i].serializeNBT());
        }
        tag.func_74768_a("timer", this.timer);
        tag.func_74768_a("waterAmount", this.currentWaterAmount);
        tag.func_74768_a("cookTime", this.cookTime);
        tag.func_74768_a("perpetualstew_totalFoods", this.totalFoods);
        tag.func_74768_a("perpetualstew_totalPoisonous", this.totalPoisonous);
        tag.func_74768_a("perpetualstew_totalMeats", this.totalMeats);
        tag.func_74768_a("perpetualstew_totalVeggies", this.totalVeggies);
        tag.func_74768_a("perpetualstew_totalSweets", this.totalSweets);
        tag.func_74768_a("perpetualstew_totalMagic", this.totalMagic);
        return super.func_189515_b(tag);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        this.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public boolean addWater(int amount) {
        if (this.currentWaterAmount <= this.waterCapacity) {
            this.currentWaterAmount += amount;
            if (this.currentWaterAmount > this.waterCapacity) {
                this.currentWaterAmount = this.waterCapacity;
            }
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
            return true;
        }
        return false;
    }

    public boolean removeWater(int amount) {
        if (this.currentWaterAmount >= amount) {
            this.currentWaterAmount -= amount;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
            return true;
        }
        return false;
    }

    public int getWater() {
        return this.currentWaterAmount;
    }

    public ItemStack addFood(ItemStack food, PlayerEntity player) {
        for (int i = 0; i < this.lastTenItems.length - 1; ++i) {
            this.lastTenItems[i] = this.lastTenItems[i + 1];
        }
        ItemStack temp = food.func_77946_l();
        temp.func_190918_g(food.func_190916_E() - 1);
        this.lastTenItems[this.lastTenItems.length - 1] = temp;
        this.color = this.getAverageColor();
        this.updateNutritionStats(food, player);
        ItemStack cp = food.func_77946_l();
        cp.func_190918_g(1);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        return cp;
    }

    private int getAverageColor() {
        int redSum = 0;
        int greenSum = 0;
        int blueSum = 0;
        for (int i = 0; i < this.lastTenItems.length; ++i) {
            int color = FoodInfo.getFoodColor(this.lastTenItems[i].func_77973_b());
            redSum += color >> 16 & 0xFF;
            greenSum += color >> 8 & 0xFF;
            blueSum += color >> 0 & 0xFF;
        }
        return ((redSum /= this.lastTenItems.length) << 16) + ((greenSum /= this.lastTenItems.length) << 8) + (blueSum /= this.lastTenItems.length);
    }

    public int getHunger() {
        return 4 + (int)Math.floor(Math.log(this.totalFoods) / Math.log(2.0));
    }

    public float getSaturationMod() {
        int totalNormalFoods = this.totalMeats + this.totalSweets + this.totalVeggies;
        float minAmount = (float)Math.min(Math.min(this.totalMeats, this.totalSweets), this.totalVeggies) * 1.0f / (float)totalNormalFoods;
        float maxAmount = (float)Math.max(Math.max(this.totalMeats, this.totalSweets), this.totalVeggies) * 1.0f / (float)totalNormalFoods;
        float fdd = maxAmount - minAmount;
        int saturationTier = fdd < 0.1f ? 4 : (fdd < 0.3f ? 3 : 2);
        if ((float)this.totalMagic * 1.0f / (float)this.totalFoods > 0.1f && this.totalMagic > this.totalPoisonous) {
            ++saturationTier;
        }
        if (this.totalPoisonous > this.totalMagic) {
            saturationTier = 1;
        }
        switch (saturationTier) {
            case 1: {
                return 0.2f;
            }
            case 2: {
                return 0.6f;
            }
            case 3: {
                return 1.2f;
            }
            case 4: {
                return 1.6f;
            }
            case 5: {
                return 2.4f;
            }
        }
        return 0.0f;
    }

    private void updateNutritionStats(ItemStack food, PlayerEntity player) {
        ++this.totalFoods;
        switch (FoodInfo.getFoodType(food.func_77973_b())) {
            case Meat: {
                ++this.totalMeats;
                break;
            }
            case Magic: {
                ++this.totalMagic;
                break;
            }
            case Poison: {
                ++this.totalPoisonous;
                break;
            }
            case Sweets: {
                ++this.totalSweets;
                break;
            }
            case Veggie: {
                ++this.totalVeggies;
            }
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.add_item", new Object[]{new TranslationTextComponent(food.func_77977_a())}), false);
        this.displayQualityInfo(player);
    }

    public void displayQualityInfo(PlayerEntity player) {
        int totalNormalFoods = this.totalMeats + this.totalSweets + this.totalVeggies;
        float minAmount = (float)Math.min(Math.min(this.totalMeats, this.totalSweets), this.totalVeggies) * 1.0f / (float)totalNormalFoods;
        float maxAmount = (float)Math.max(Math.max(this.totalMeats, this.totalSweets), this.totalVeggies) * 1.0f / (float)totalNormalFoods;
        float fdd = maxAmount - minAmount;
        if (this.totalPoisonous > this.totalMagic) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.poison_stew"), false);
        } else {
            if (fdd < 0.1f) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.great_flavor"), false);
            } else if (fdd < 0.3f) {
                if (this.totalMeats > this.totalSweets && this.totalMeats > this.totalVeggies) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.too_much_meat"), false);
                } else if (this.totalSweets > this.totalMeats && this.totalSweets > this.totalVeggies) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.too_much_sweet"), false);
                } else if (this.totalVeggies > this.totalMeats && this.totalVeggies > this.totalSweets) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.too_much_veggie"), false);
                } else if (this.totalVeggies == this.totalMeats) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.needs_sweet"), false);
                } else if (this.totalVeggies == this.totalSweets) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.needs_meat"), false);
                } else if (this.totalSweets == this.totalMeats) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.needs_veggie"), false);
                }
            } else if (this.totalMeats > this.totalSweets && this.totalMeats > this.totalVeggies) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.way_too_much_meat"), false);
            } else if (this.totalSweets > this.totalMeats && this.totalSweets > this.totalVeggies) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.way_too_much_sweet"), false);
            } else if (this.totalVeggies > this.totalMeats && this.totalVeggies > this.totalSweets) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.way_too_much_veggie"), false);
            } else if (this.totalVeggies == this.totalMeats) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.really_needs_sweet"), false);
            } else if (this.totalVeggies == this.totalSweets) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.really_needs_meat"), false);
            } else if (this.totalSweets == this.totalMeats) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.really_needs_veggie"), false);
            }
            if ((float)this.totalMagic * 1.0f / (float)this.totalFoods > 0.1f && this.totalMagic > this.totalPoisonous) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.perpetualstew.magic_stew"), false);
            }
        }
    }
}

