/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FallenTreeFeature
extends Feature<NoFeatureConfig> {
    public static final Set<Pair<String, Block>> LOGS = new HashSet<Pair<String, Block>>();

    public FallenTreeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockState state = this.getLog(world, pos);
        if (state == null) {
            return false;
        }
        BlockState b = world.func_180495_p(pos.func_177977_b());
        if (b.func_185904_a() == Material.field_151588_w || b.func_185904_a() == Material.field_151588_w || b.func_177230_c() == Blocks.field_196604_cC) {
            return false;
        }
        boolean branching = rand.nextBoolean();
        BlockPos temp = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int length = rand.nextInt(3) + 4;
        Direction dir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        while (length > 0) {
            if (world.func_180495_p(pos).func_185904_a().func_76222_j()) {
                positions.add(pos);
                --length;
                if (!world.func_180495_p((pos = pos.func_177971_a(dir.func_176730_m())).func_177977_b()).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150355_j) continue;
                if (world.func_180495_p(temp = temp.func_177971_a(dir.func_176734_d().func_176730_m())).func_185904_a().func_76222_j()) {
                    positions.add(temp);
                    --length;
                    continue;
                }
                return false;
            }
            return false;
        }
        for (BlockPos p : positions) {
            world.func_180501_a(p, (BlockState)state.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)dir.func_176740_k()), 2);
            if (!branching || !rand.nextBoolean()) continue;
            Direction d = rand.nextBoolean() ? dir.func_176746_e() : dir.func_176735_f();
            BlockPos branchPos = p.func_177971_a(d.func_176730_m());
            if (world.func_180495_p(branchPos).func_185904_a().func_76222_j() || world.func_175623_d(branchPos)) {
                world.func_180501_a(branchPos, (BlockState)state.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)d.func_176740_k()), 2);
            }
            branching = false;
        }
        return true;
    }

    private BlockState getLog(ISeedReader world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        List logs = LOGS.stream().filter(pair -> ((String)pair.getFirst()).equals(biome.getRegistryName().toString())).map(pair -> (Block)pair.getSecond()).collect(Collectors.toList());
        if (logs.size() > 0) {
            return ((Block)logs.get(world.func_201674_k().nextInt(logs.size()))).func_176223_P();
        }
        return null;
    }
}

