/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import projectvibrantjourneys.core.PVJConfig;
import projectvibrantjourneys.init.object.PVJEntities;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys")
public class PVJEntitySpawnEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void setSpawns(BiomeLoadingEvent event) {
        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
        Set biomeTypes = BiomeDictionary.getTypes((RegistryKey)biome);
        List spawners = event.getSpawns().getSpawner(PVJEntities.PVJ_AMBIENT);
        List water_spawners = event.getSpawns().getSpawner(PVJEntities.PVJ_WATER_AMBIENT);
        List night_spawners = event.getSpawns().getSpawner(PVJEntities.PVJ_NIGHT_AMBIENT);
        if (biomeTypes.contains(BiomeDictionary.Type.OVERWORLD)) {
            if (PVJEntitySpawnEvents.doesNotHave(biomeTypes, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MUSHROOM) && event.getCategory() != Biome.Category.DESERT) {
                if (((Boolean)PVJConfig.enableFlies.get()).booleanValue()) {
                    spawners.add(new MobSpawnInfo.Spawners(PVJEntities.FLY, 15, 1, 3));
                }
                if (((Boolean)PVJConfig.enableFireflies.get()).booleanValue()) {
                    night_spawners.add(new MobSpawnInfo.Spawners(PVJEntities.FIREFLY, 50, 1, 5));
                }
                if (((Boolean)PVJConfig.nightBats.get()).booleanValue()) {
                    night_spawners.add(new MobSpawnInfo.Spawners(PVJEntities.NIGHT_BAT, 10, 1, 3));
                }
                if (((Boolean)PVJConfig.enableSnails.get()).booleanValue()) {
                    spawners.add(new MobSpawnInfo.Spawners(PVJEntities.SNAIL, 30, 1, 3));
                }
                if (((Boolean)PVJConfig.enableSlugs.get()).booleanValue()) {
                    spawners.add(new MobSpawnInfo.Spawners(PVJEntities.SLUG, 25, 1, 3));
                }
                if (((Boolean)PVJConfig.enableSmallSpiders.get()).booleanValue()) {
                    spawners.add(new MobSpawnInfo.Spawners(PVJEntities.SMALL_SPIDER, 5, 1, 1));
                }
            }
            if (biomeTypes.contains(BiomeDictionary.Type.BEACH) && !biomeTypes.contains(BiomeDictionary.Type.MUSHROOM) && ((Boolean)PVJConfig.enableStarfish.get()).booleanValue()) {
                spawners.add(new MobSpawnInfo.Spawners(PVJEntities.STARFISH, 30, 1, 3));
            }
            if (biomeTypes.contains(BiomeDictionary.Type.OCEAN) && ((Boolean)PVJConfig.enableStarfish.get()).booleanValue()) {
                water_spawners.add(new MobSpawnInfo.Spawners(PVJEntities.OCEAN_STARFISH, 15, 1, 4));
            }
            if (!biomeTypes.contains(BiomeDictionary.Type.WASTELAND) && event.getCategory() != Biome.Category.DESERT && ((Boolean)PVJConfig.enableClams.get()).booleanValue()) {
                water_spawners.add(new MobSpawnInfo.Spawners(PVJEntities.CLAM, 10, 1, 3));
            }
            if ((biome == Biomes.field_76781_i || PVJEntitySpawnEvents.hasType(biomeTypes, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.SWAMP)) && ((Boolean)PVJConfig.enableFrogs.get()).booleanValue()) {
                spawners.add(new MobSpawnInfo.Spawners(PVJEntities.FROG, 30, 1, 2));
            }
            if ((event.getCategory() == Biome.Category.JUNGLE || PVJEntitySpawnEvents.hasType(biomeTypes, BiomeDictionary.Type.JUNGLE)) && ((Boolean)PVJConfig.jungleTropicalFish.get()).booleanValue()) {
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners(EntityType.field_204262_at, 20, 1, 8));
            }
        }
    }

    private static boolean hasType(Set<BiomeDictionary.Type> list, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type t : types) {
            if (!list.contains(t)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesNotHave(Set<BiomeDictionary.Type> list, BiomeDictionary.Type ... types) {
        List<BiomeDictionary.Type> typeList = Arrays.asList(types);
        return list.stream().noneMatch(type -> typeList.contains(type));
    }

    public static boolean canBatSpawn(EntityType<BatEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        if (pos.func_177956_o() < world.func_181545_F()) {
            return false;
        }
        if (world.func_201696_r(pos) > 9) {
            return false;
        }
        return CreatureEntity.func_223315_a(entity, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand);
    }
}

