/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init.object;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import projectvibrantjourneys.common.entities.ClamEntity;
import projectvibrantjourneys.common.entities.FireflyEntity;
import projectvibrantjourneys.common.entities.FlyEntity;
import projectvibrantjourneys.common.entities.FrogEntity;
import projectvibrantjourneys.common.entities.SlugEntity;
import projectvibrantjourneys.common.entities.SmallSpiderEntity;
import projectvibrantjourneys.common.entities.SnailEntity;
import projectvibrantjourneys.common.entities.StarfishEntity;
import projectvibrantjourneys.init.PVJEntitySpawnEvents;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJEntities {
    public static final EntityClassification PVJ_AMBIENT = EntityClassification.create((String)"pvj_ambient", (String)"pvj_ambient", (int)15, (boolean)true, (boolean)false, (int)128);
    public static final EntityClassification PVJ_WATER_AMBIENT = EntityClassification.create((String)"pvj_water_ambient", (String)"pvj_water_ambient", (int)15, (boolean)true, (boolean)false, (int)128);
    public static final EntityClassification PVJ_NIGHT_AMBIENT = EntityClassification.create((String)"pvj_night_ambient", (String)"pvj_night_ambient", (int)25, (boolean)true, (boolean)false, (int)128);
    public static final List<EntityType<?>> ENTITIES = new ArrayList();
    public static final EntityType<FlyEntity> FLY = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(FlyEntity::new, (EntityClassification)PVJ_AMBIENT).func_220321_a(0.1f, 0.1f), "fly");
    public static final EntityType<FireflyEntity> FIREFLY = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(FireflyEntity::new, (EntityClassification)PVJ_NIGHT_AMBIENT).func_220321_a(0.1f, 0.1f), "firefly");
    public static final EntityType<StarfishEntity> STARFISH = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(StarfishEntity::new, (EntityClassification)PVJ_AMBIENT).func_220321_a(0.4f, 0.1f), "starfish");
    public static final EntityType<StarfishEntity> OCEAN_STARFISH = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(StarfishEntity::new, (EntityClassification)PVJ_WATER_AMBIENT).func_220321_a(0.4f, 0.1f), "ocean_starfish");
    public static final EntityType<ClamEntity> CLAM = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(ClamEntity::new, (EntityClassification)PVJ_WATER_AMBIENT).func_220321_a(0.45f, 0.25f), "clam");
    public static final EntityType<SnailEntity> SNAIL = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(SnailEntity::new, (EntityClassification)PVJ_AMBIENT).func_220321_a(0.25f, 0.15f), "snail");
    public static final EntityType<SlugEntity> SLUG = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(SlugEntity::new, (EntityClassification)PVJ_AMBIENT).func_220321_a(0.25f, 0.1f), "slug");
    public static final EntityType<SmallSpiderEntity> SMALL_SPIDER = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(SmallSpiderEntity::new, (EntityClassification)PVJ_AMBIENT).func_220321_a(0.28f, 0.18f), "small_spider");
    public static final EntityType<FrogEntity> FROG = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(FrogEntity::new, (EntityClassification)PVJ_AMBIENT).func_220321_a(0.45f, 0.3f), "frog");
    public static final EntityType<BatEntity> NIGHT_BAT = PVJEntities.registerEntity(EntityType.Builder.func_220322_a(BatEntity::new, (EntityClassification)PVJ_NIGHT_AMBIENT).func_220321_a(0.5f, 0.9f), "night_bat");

    public static <T extends Entity> EntityType<T> registerEntity(EntityType.Builder<?> builder, String name) {
        EntityType entity = (EntityType)builder.func_206830_a(name).setRegistryName(new ResourceLocation("projectvibrantjourneys", name));
        ENTITIES.add(entity);
        return entity;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        ENTITIES.forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        PVJEntities.registerSpawnPlacements();
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(FLY, FlyEntity.createAttributes().func_233813_a_());
        event.put(FIREFLY, FlyEntity.createAttributes().func_233813_a_());
        event.put(STARFISH, StarfishEntity.createAttributes().func_233813_a_());
        event.put(OCEAN_STARFISH, StarfishEntity.createAttributes().func_233813_a_());
        event.put(CLAM, ClamEntity.createAttributes().func_233813_a_());
        event.put(SNAIL, SnailEntity.createAttributes().func_233813_a_());
        event.put(SLUG, SlugEntity.createAttributes().func_233813_a_());
        event.put(SMALL_SPIDER, SmallSpiderEntity.createAttributes().func_233813_a_());
        event.put(FROG, FrogEntity.createAttributes().func_233813_a_());
        event.put(NIGHT_BAT, BatEntity.func_234175_m_().func_233813_a_());
    }

    public static void registerSpawnPlacements() {
        EntitySpawnPlacementRegistry.func_209343_a(FLY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FlyEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(FIREFLY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FireflyEntity::canSpawnFirefly);
        EntitySpawnPlacementRegistry.func_209343_a(STARFISH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StarfishEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(OCEAN_STARFISH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR, StarfishEntity::canSpawnOcean);
        EntitySpawnPlacementRegistry.func_209343_a(CLAM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR, ClamEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(SNAIL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SnailEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(SLUG, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SlugEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(SMALL_SPIDER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SmallSpiderEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(FROG, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FrogEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(NIGHT_BAT, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PVJEntitySpawnEvents::canBatSpawn);
    }
}

