/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import projectvibrantjourneys.common.biomes.OvergrownSpiresBiome;
import projectvibrantjourneys.common.biomes.VerdantSandsBiome;
import projectvibrantjourneys.core.PVJConfig;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJBiomes {
    public static final List<Biome> BIOMES = new ArrayList<Biome>();
    public static Biome overgrown_spires = PVJBiomes.register(OvergrownSpiresBiome.makeShatteredJungleBiome(), "overgrown_spires");
    public static Biome verdant_sands = PVJBiomes.register(VerdantSandsBiome.makeVerdantSandsBiome(), "verdant_sands");

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        BIOMES.forEach(biome -> event.getRegistry().register((IForgeRegistryEntry)biome));
        PVJBiomes.addBiomes();
        PVJBiomes.addTypes();
    }

    public static Biome register(Biome biome, String name) {
        biome.setRegistryName(new ResourceLocation("projectvibrantjourneys", name));
        BIOMES.add(biome);
        return biome;
    }

    public static void addBiomes() {
        if (((Boolean)PVJConfig.overgrownSpires.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.OVERGROWN_SPIRES, 10));
        }
        if (((Boolean)PVJConfig.verdantSands.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(Keys.VERDANT_SANDS, 10));
        }
    }

    public static void addTypes() {
        BiomeDictionary.addTypes(Keys.OVERGROWN_SPIRES, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes(Keys.VERDANT_SANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD});
    }

    public static class Keys {
        public static final RegistryKey<Biome> OVERGROWN_SPIRES = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "overgrown_spires"));
        public static final RegistryKey<Biome> VERDANT_SANDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", "verdant_sands"));
    }
}

