/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init.world;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import projectvibrantjourneys.common.world.features.blockplacers.GroundcoverPlacer;
import projectvibrantjourneys.common.world.features.blockplacers.RocksBlockPlacer;
import projectvibrantjourneys.common.world.features.blockstateproviders.ShortGrassBlockStateProvider;
import projectvibrantjourneys.init.object.PVJBlocks;
import projectvibrantjourneys.init.world.PVJFeatures;

public class PVJConfiguredFeatures {
    public static final GroundcoverPlacer GROUNDCOVER_PLACER = new GroundcoverPlacer();
    public static BlockClusterFeatureConfig twigsCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.twigs.func_176223_P()), GROUNDCOVER_PLACER, 5);
    public static BlockClusterFeatureConfig fallenLeavesCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.fallen_leaves.func_176223_P()), GROUNDCOVER_PLACER, 5);
    public static BlockClusterFeatureConfig rocksCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.rocks.func_176223_P()), new RocksBlockPlacer(), 5);
    public static BlockClusterFeatureConfig iceChunksCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.ice_chunks.func_176223_P()), GROUNDCOVER_PLACER, 5);
    public static BlockClusterFeatureConfig bonesCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.bones.func_176223_P()), GROUNDCOVER_PLACER, 1);
    public static BlockClusterFeatureConfig charredBonesCluster = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.charred_bones.func_176223_P()), (BlockPlacer)new GroundcoverPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static BlockClusterFeatureConfig pineconesCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.pinecones.func_176223_P()), GROUNDCOVER_PLACER, 4);
    public static BlockClusterFeatureConfig seashellsCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.seashells.func_176223_P()), GROUNDCOVER_PLACER, 5);
    public static BlockClusterFeatureConfig seaOatsCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.sea_oats.func_176223_P()), (BlockPlacer)DoublePlantBlockPlacer.field_236444_c_, 15);
    public static BlockClusterFeatureConfig cattailCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.cattail.func_176223_P()), (BlockPlacer)DoublePlantBlockPlacer.field_236444_c_, 15);
    public static BlockClusterFeatureConfig glowcapCluster = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.glowcap.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static BlockStateProvidingFeatureConfig crimsonNettleConfig = new BlockStateProvidingFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.crimson_nettle.func_176223_P()));
    public static BlockStateProvidingFeatureConfig warpedNettleConfig = new BlockStateProvidingFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.warped_nettle.func_176223_P()));
    public static BlockClusterFeatureConfig shortGrassCluster = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ShortGrassBlockStateProvider(), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(16).func_227322_d_();
    public static BlockClusterFeatureConfig beachGrassCluster = PVJConfiguredFeatures.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.beach_grass.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_, 15);
    public static ConfiguredFeature<?, ?> sea_oats;
    public static ConfiguredFeature<?, ?> cattails;
    public static ConfiguredFeature<?, ?> water_cattails;
    public static ConfiguredFeature<?, ?> twigs;
    public static ConfiguredFeature<?, ?> fallen_leaves;
    public static ConfiguredFeature<?, ?> rocks;
    public static ConfiguredFeature<?, ?> ice_chunks;
    public static ConfiguredFeature<?, ?> bones;
    public static ConfiguredFeature<?, ?> charred_bones;
    public static ConfiguredFeature<?, ?> pinecones;
    public static ConfiguredFeature<?, ?> seashells;
    public static ConfiguredFeature<?, ?> ocean_seashells;
    public static ConfiguredFeature<?, ?> bushes;
    public static ConfiguredFeature<?, ?> bark_mushrooms;
    public static ConfiguredFeature<?, ?> cobwebs;
    public static ConfiguredFeature<?, ?> glowcap;
    public static ConfiguredFeature<?, ?> crimson_nettle;
    public static ConfiguredFeature<?, ?> warped_nettle;
    public static ConfiguredFeature<?, ?> short_grass;
    public static ConfiguredFeature<?, ?> beach_grass;
    public static ConfiguredFeature<?, ?> fallen_tree;
    public static ConfiguredFeature<?, ?> overgrown_spires_vegetation;

    public static void init() {
        sea_oats = PVJConfiguredFeatures.register("sea_oats", (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)seaOatsCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2));
        cattails = PVJConfiguredFeatures.register("cattail", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)cattailCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(5)).func_242729_a(2));
        water_cattails = PVJConfiguredFeatures.register("water_cattail", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)PVJFeatures.waterCattailFeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242728_a()).func_242731_b(30)).func_242729_a(3));
        twigs = PVJConfiguredFeatures.register("twigs", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)twigsCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(3)).func_242729_a(2));
        fallen_leaves = PVJConfiguredFeatures.register("fallen_leaves", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)fallenLeavesCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(4)).func_242729_a(2));
        rocks = PVJConfiguredFeatures.register("rocks", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)rocksCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(3)).func_242729_a(2));
        ice_chunks = PVJConfiguredFeatures.register("ice_chunks", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)iceChunksCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2)).func_242729_a(2));
        bones = PVJConfiguredFeatures.register("bones", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)bonesCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1)).func_242729_a(2));
        charred_bones = PVJConfiguredFeatures.register("charred_bones", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)charredBonesCluster).func_242733_d(128)).func_242729_a(2));
        pinecones = PVJConfiguredFeatures.register("pinecones", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)pineconesCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2)).func_242729_a(2));
        seashells = PVJConfiguredFeatures.register("seashells", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)seashellsCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(3)).func_242729_a(2));
        ocean_seashells = PVJConfiguredFeatures.register("ocean_seashells", (ConfiguredFeature)((ConfiguredFeature)PVJFeatures.oceanFloorSeashellsFeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244003_n).func_242731_b(10)).func_242729_a(2));
        bushes = PVJConfiguredFeatures.register("bush", PVJFeatures.bushFeature.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.3f)).func_227228_a_(Features.Placements.field_243996_g));
        bark_mushrooms = PVJConfiguredFeatures.register("bark_mushroom", (ConfiguredFeature)((ConfiguredFeature)PVJFeatures.barkMushroomFeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242728_a()).func_242731_b(30));
        cobwebs = PVJConfiguredFeatures.register("cobwebs", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)PVJFeatures.cobwebFeature.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.1f)).func_242728_a()).func_242731_b(30)).func_242729_a(25));
        glowcap = PVJConfiguredFeatures.register("glowcap", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)glowcapCluster).func_242733_d(128)).func_242729_a(2));
        crimson_nettle = PVJConfiguredFeatures.register("crimson_nettle", ((ConfiguredFeature)Feature.field_236282_M_.func_225566_b_((IFeatureConfig)crimsonNettleConfig).func_242729_a(40)).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(4))));
        warped_nettle = PVJConfiguredFeatures.register("warped_nettle", ((ConfiguredFeature)Feature.field_236282_M_.func_225566_b_((IFeatureConfig)warpedNettleConfig).func_242729_a(40)).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(4))));
        short_grass = PVJConfiguredFeatures.register("short_grass", (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)shortGrassCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(5));
        beach_grass = PVJConfiguredFeatures.register("beach_grass", (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)beachGrassCluster).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2));
        overgrown_spires_vegetation = PVJConfiguredFeatures.register("overgrown_spires_vegetation", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Features.field_243869_bO.func_227227_a_(0.1f), (Object)Features.field_243876_bV.func_227227_a_(0.5f), (Object)Features.field_243871_bQ.func_227227_a_(0.33333334f)), Features.field_243868_bN)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(15, 0.4f, 1))));
        fallen_tree = PVJConfiguredFeatures.register("fallen_tree", PVJFeatures.fallenTreeFeature.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_243995_f));
    }

    private static BlockClusterFeatureConfig makeFeatureConfig(BlockStateProvider provider, BlockPlacer placer, int tries) {
        return new BlockClusterFeatureConfig.Builder(provider, placer).func_227315_a_(tries).func_227322_d_();
    }

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String key, ConfiguredFeature<FC, ?> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", key), configuredFeature);
    }
}

