/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init.world;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import projectvibrantjourneys.common.world.features.BarkMushroomFeature;
import projectvibrantjourneys.common.world.features.BushFeature;
import projectvibrantjourneys.common.world.features.CobwebFeature;
import projectvibrantjourneys.common.world.features.FallenTreeFeature;
import projectvibrantjourneys.common.world.features.OceanFloorSeashellsFeature;
import projectvibrantjourneys.common.world.features.WaterCattailFeature;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJFeatures {
    public static final ArrayList<Feature<?>> FEATURES = new ArrayList();
    public static Feature<NoFeatureConfig> oceanFloorSeashellsFeature;
    public static Feature<ProbabilityConfig> bushFeature;
    public static Feature<NoFeatureConfig> waterCattailFeature;
    public static Feature<NoFeatureConfig> barkMushroomFeature;
    public static Feature<ProbabilityConfig> cobwebFeature;
    public static Feature<NoFeatureConfig> fallenTreeFeature;

    @SubscribeEvent
    public static void initFeatures(RegistryEvent.Register<Feature<?>> event) {
        oceanFloorSeashellsFeature = PVJFeatures.registerFeature(new OceanFloorSeashellsFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), "ocean_floor_seashells_feature");
        bushFeature = PVJFeatures.registerFeature(new BushFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_), "bush_feature");
        waterCattailFeature = PVJFeatures.registerFeature(new WaterCattailFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), "water_cattail_feature");
        barkMushroomFeature = PVJFeatures.registerFeature(new BarkMushroomFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), "bark_mushroom_feature");
        cobwebFeature = PVJFeatures.registerFeature(new CobwebFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_), "cobweb_feature");
        fallenTreeFeature = PVJFeatures.registerFeature(new FallenTreeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), "fallen_tree_feature");
        FEATURES.forEach((Consumer<Feature<?>>)((Consumer<Feature>)feature -> event.getRegistry().register((IForgeRegistryEntry)feature)));
    }

    public static <FC extends IFeatureConfig> Feature<FC> registerFeature(Feature<FC> feature, String name) {
        feature.setRegistryName(new ResourceLocation("projectvibrantjourneys", name));
        FEATURES.add(feature);
        return feature;
    }
}

