/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import projectvibrantjourneys.common.world.features.FallenTreeFeature;
import projectvibrantjourneys.core.PVJConfig;
import projectvibrantjourneys.core.ProjectVibrantJourneys;
import projectvibrantjourneys.init.world.PVJBiomes;
import projectvibrantjourneys.init.world.PVJConfiguredFeatures;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys")
public class PVJWorldGen {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addBiomeFeatures(BiomeLoadingEvent event) {
        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
        Set biomeTypes = BiomeDictionary.getTypes((RegistryKey)biome);
        List vegetalFeatures = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
        if (!((List)PVJConfig.groundcoverBlacklist.get()).contains(event.getName().toString())) {
            if (event.getCategory() == Biome.Category.NETHER) {
                if (((Boolean)PVJConfig.charredBones.get()).booleanValue()) {
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.charred_bones);
                }
            } else if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OVERWORLD)) {
                if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS)) {
                    if (((Boolean)PVJConfig.twigs.get()).booleanValue()) {
                        vegetalFeatures.add(() -> PVJConfiguredFeatures.twigs);
                    }
                    if (((Boolean)PVJConfig.fallenLeaves.get()).booleanValue()) {
                        vegetalFeatures.add(() -> PVJConfiguredFeatures.fallen_leaves);
                    }
                }
                if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.SNOWY) && ((Boolean)PVJConfig.iceChunks.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.ice_chunks);
                }
                if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.CONIFEROUS) && ((Boolean)PVJConfig.pinecones.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.pinecones);
                }
                if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) && ((Boolean)PVJConfig.seashells.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.seashells);
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.ocean_seashells);
                }
                if (!PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.MUSHROOM) && ((Boolean)PVJConfig.rocks.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.rocks);
                }
                if (!PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.MUSHROOM) && ((Boolean)PVJConfig.bones.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.bones);
                }
            }
        }
        if (event.getCategory() == Biome.Category.NETHER) {
            if (((Boolean)PVJConfig.glowcap.get()).booleanValue()) {
                event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.glowcap);
            }
            if (((Boolean)PVJConfig.netherNettles.get()).booleanValue()) {
                if (biome == Biomes.field_235253_az_) {
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.crimson_nettle);
                }
                if (biome == Biomes.field_235250_aA_) {
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.warped_nettle);
                }
            }
        } else if (event.getCategory() != Biome.Category.THEEND && event.getCategory() != Biome.Category.MUSHROOM) {
            if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) && !PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.SNOWY) && ((Boolean)PVJConfig.seaOats.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.sea_oats);
            }
            if (!PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) && event.getCategory() != Biome.Category.DESERT && ((Boolean)PVJConfig.cattails.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.cattails);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.water_cattails);
            }
            if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.PLAINS) && ((Boolean)PVJConfig.bushes.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.bushes);
            }
            if (((Boolean)PVJConfig.barkMushrooms.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.bark_mushrooms);
            }
            if (((Boolean)PVJConfig.shortGrass.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.short_grass);
            }
            if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) && !PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.SNOWY) && ((Boolean)PVJConfig.beachGrass.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.beach_grass);
            }
            if (((Boolean)PVJConfig.cobwebs.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.cobwebs);
            }
            if (event.getCategory() != Biome.Category.DESERT && event.getCategory() != Biome.Category.MESA && event.getCategory() != Biome.Category.RIVER && event.getCategory() != Biome.Category.OCEAN && ((Boolean)PVJConfig.moreSeagrass.get()).booleanValue()) {
                vegetalFeatures.add(() -> Features.field_243963_w);
            }
            if (event.getCategory() == Biome.Category.RIVER && ((Boolean)PVJConfig.moreGrassInRivers.get()).booleanValue()) {
                vegetalFeatures.add(() -> Features.field_243848_au);
            }
            if (biome == PVJBiomes.Keys.OVERGROWN_SPIRES) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.overgrown_spires_vegetation);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void addFallenTreeFeatures(BiomeLoadingEvent event) {
        if (!((Boolean)PVJConfig.fallenTrees.get()).booleanValue()) {
            return;
        }
        try {
            ProjectVibrantJourneys.LOGGER.debug(event.getName().toString());
            List features = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
            RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
            Set biomeTypes = BiomeDictionary.getTypes((RegistryKey)biome);
            ArrayList trees = new ArrayList();
            for (Supplier cf : features) {
                PVJWorldGen.getFeatureNames((ConfiguredFeature)cf.get(), trees);
            }
            Random rand = new Random();
            for (ConfiguredFeature configuredFeature : trees) {
                if (!(configuredFeature.func_242767_c() instanceof BaseTreeFeatureConfig)) continue;
                try {
                    Block block = ((BaseTreeFeatureConfig)configuredFeature.func_242767_c()).field_227368_m_.func_225574_a_(rand, null).func_177230_c();
                    if (!(block instanceof RotatedPillarBlock)) continue;
                    ProjectVibrantJourneys.LOGGER.debug("----> " + block.getRegistryName());
                    FallenTreeFeature.LOGS.add((Pair<String, Block>)new Pair((Object)event.getName().toString(), (Object)block));
                }
                catch (Exception exception) {}
            }
            if (trees.size() > 0) {
                features.add(() -> {
                    float chance = 0.1f;
                    if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY)) {
                        chance = 0.05f;
                    }
                    return PVJConfiguredFeatures.fallen_tree.func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, chance, 1)));
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFeatureNames(ConfiguredFeature<?, ?> cf, List<ConfiguredFeature<?, ?>> list) {
        if (Feature.field_202292_al.getRegistryName().equals((Object)cf.func_242766_b().getRegistryName())) {
            ((MultipleRandomFeatureConfig)cf.func_242767_c()).field_202449_a.forEach(s -> list.add((ConfiguredFeature<?, ?>)s.field_214842_a.get()));
        } else if (cf.func_242767_c() instanceof DecoratedFeatureConfig) {
            ConfiguredFeature feature = (ConfiguredFeature)((DecoratedFeatureConfig)cf.func_242767_c()).field_214689_a.get();
            if (feature.func_242767_c() instanceof BaseTreeFeatureConfig) {
                list.add(feature);
            } else {
                return PVJWorldGen.getFeatureNames(feature, list);
            }
        }
        return cf.func_242766_b().getRegistryName().toString();
    }

    private static boolean hasType(Set<BiomeDictionary.Type> list, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type t : types) {
            if (!list.contains(t)) continue;
            return true;
        }
        return false;
    }
}

