/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword;

import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.particle.BleedParticle;
import mod.vemerion.runesword.particle.MagicBallParticle;
import mod.vemerion.runesword.renderer.RuneforgeTileEntityRenderer;
import mod.vemerion.runesword.screen.RuneforgeScreen;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.SnowManRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="runesword", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEventSubscriber {
    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)Main.RUNEFORGE_BLOCK, (RenderType)RenderType.func_228643_e_());
        ClientRegistry.bindTileEntityRenderer(Main.RUNEFORGE_TILE_ENTITY, RuneforgeTileEntityRenderer::new);
        ScreenManager.func_216911_a(Main.RUNEFORGE_CONTAINER, RuneforgeScreen::new);
        RenderingRegistry.registerEntityRenderingHandler(Main.FROST_GOLEM_ENTITY, SnowManRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(Main.MAGIC_BALL_ENTITY, NoRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(Main.FROSTBALL_ENTITY, r -> new SpriteRenderer(r, Minecraft.func_71410_x().func_175599_af()));
    }

    @SubscribeEvent
    public static void onRegisterParticleFactory(ParticleFactoryRegisterEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71452_i.func_215234_a(Main.MAGIC_BALL_PARTICLE, s -> new MagicBallParticle.Factory(s));
        mc.field_71452_i.func_215234_a((ParticleType)Main.BLEED_PARTICLE, s -> new BleedParticle.Factory(s));
    }

    @SubscribeEvent
    public static void onRegisterColor(ColorHandlerEvent.Item event) {
        for (RuneItem rune : RuneItem.getRunes()) {
            event.getItemColors().func_199877_a((stack, layer) -> layer == 0 ? -1 : rune.getColor(), new IItemProvider[]{rune});
        }
    }

    private static class NoRenderer<T extends Entity>
    extends EntityRenderer<T> {
        protected NoRenderer(EntityRendererManager renderManager) {
            super(renderManager);
        }

        public ResourceLocation func_110775_a(T entity) {
            return null;
        }
    }
}

