/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword;

import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.capability.EntityRuneData;
import mod.vemerion.runesword.capability.Runes;
import mod.vemerion.runesword.effect.BleedEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="runesword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    @SubscribeEvent
    public static void synchBleeding(PlayerEvent.StartTracking event) {
        PlayerEntity player = event.getPlayer();
        Entity target = event.getTarget();
        if (!player.field_70170_p.field_72995_K && target instanceof LivingEntity) {
            EntityRuneData.synchBleeding(player, (LivingEntity)target);
        }
    }

    @SubscribeEvent
    public static void bleeding(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            boolean isBleeding = entity.func_70644_a((Effect)Main.BLEED_EFFECT);
            EntityRuneData.get((Entity)entity).ifPresent(d -> {
                if (isBleeding != d.isBleeding()) {
                    EntityRuneData.synchBleeding(entity);
                }
                d.setBleeding(isBleeding);
            });
        } else {
            EntityRuneData.get((Entity)entity).ifPresent(d -> {
                if (d.isBleeding() && entity.field_70173_aa % 10 == 0) {
                    BleedEffect.addBleedingParticles(entity);
                }
            });
        }
    }

    @SubscribeEvent
    public static void runeAttack(AttackEntityEvent event) {
        event.getPlayer().func_184614_ca().getCapability(Runes.CAPABILITY).ifPresent(runes -> runes.onAttack(event.getPlayer(), event.getTarget()));
    }

    @SubscribeEvent
    public static void runeKill(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            player.func_184614_ca().getCapability(Runes.CAPABILITY).ifPresent(runes -> runes.onKill(player, event.getEntityLiving(), event.getSource()));
        }
    }

    @SubscribeEvent
    public static void runeTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            event.player.func_184614_ca().getCapability(Runes.CAPABILITY).ifPresent(runes -> runes.tick(event.player));
        }
    }

    @SubscribeEvent
    public static void runeHurt(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        event.getEntityLiving().func_184614_ca().getCapability(Runes.CAPABILITY).ifPresent(runes -> event.setAmount(runes.onHurt((PlayerEntity)event.getEntityLiving(), event.getSource(), event.getAmount())));
    }

    @SubscribeEvent
    public static void runeRightClick(PlayerInteractEvent.RightClickItem event) {
        event.getPlayer().func_184614_ca().getCapability(Runes.CAPABILITY).ifPresent(runes -> runes.onRightClick(event.getPlayer()));
    }

    @SubscribeEvent
    public static void runeBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.getPlayer().func_184614_ca().getCapability(Runes.CAPABILITY).ifPresent(runes -> event.setNewSpeed(runes.onBreakSpeed(event.getPlayer(), event.getState(), event.getPos(), event.getOriginalSpeed())));
    }

    @SubscribeEvent
    public static void runeHarvestCheck(PlayerEvent.HarvestCheck event) {
        event.getPlayer().func_184614_ca().getCapability(Runes.CAPABILITY).ifPresent(runes -> event.setCanHarvest(runes.onHarvestCheck(event.getPlayer(), event.getTargetBlock(), event.canHarvest())));
    }

    @SubscribeEvent
    public static void runeBlockBreak(BlockEvent.BreakEvent event) {
        event.getPlayer().func_184614_ca().getCapability(Runes.CAPABILITY).ifPresent(runes -> runes.onBlockBreak(event.getPlayer(), event.getState(), event.getPos()));
    }
}

