/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.capability;

import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.network.Network;
import mod.vemerion.runesword.network.SyncBleedingMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityRuneData
implements INBTSerializable<CompoundNBT> {
    @CapabilityInject(value=EntityRuneData.class)
    public static final Capability<EntityRuneData> CAPABILITY = null;
    private boolean isBleeding;

    public void setBleeding(boolean b) {
        this.isBleeding = b;
    }

    public boolean isBleeding() {
        return this.isBleeding;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74757_a("isBleeding", this.isBleeding);
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.isBleeding = nbt.func_74767_n("isBleeding");
    }

    public static LazyOptional<EntityRuneData> get(Entity e) {
        return e.getCapability(CAPABILITY);
    }

    public static void synchBleeding(LivingEntity e) {
        Network.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), (Object)new SyncBleedingMessage(e.func_70644_a((Effect)Main.BLEED_EFFECT), e.func_145782_y()));
    }

    public static void synchBleeding(PlayerEntity player, LivingEntity e) {
        Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SyncBleedingMessage(e.func_70644_a((Effect)Main.BLEED_EFFECT), e.func_145782_y()));
    }

    public static class Storage
    implements Capability.IStorage<EntityRuneData> {
        public INBT writeNBT(Capability<EntityRuneData> capability, EntityRuneData instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<EntityRuneData> capability, EntityRuneData instance, Direction side, INBT nbt) {
            instance.deserializeNBT((CompoundNBT)nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="runesword", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Provider
    implements ICapabilitySerializable<INBT> {
        private static final ResourceLocation SAVE_LOCATION = new ResourceLocation("runesword", "entityrunedata");
        private LazyOptional<EntityRuneData> instance = LazyOptional.of(() -> new EntityRuneData());

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof LivingEntity) {
                event.addCapability(SAVE_LOCATION, (ICapabilityProvider)new Provider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public INBT serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null);
        }

        public void deserializeNBT(INBT nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null, nbt);
        }
    }
}

