/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.capability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.item.RunePowers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

public class Runes
extends ItemStackHandler {
    @CapabilityInject(value=Runes.class)
    public static final Capability<Runes> CAPABILITY = null;
    public static final int RUNES_COUNT = 4;
    public static final int MAJOR_SLOT = 0;
    public static final int FIRST_MINOR_SLOT = 1;
    public static final int SECOND_MINOR_SLOT = 2;
    public static final int THIRD_MINOR_SLOT = 3;
    private ItemStack owner;

    public Runes() {
        this(ItemStack.field_190927_a);
    }

    public Runes(ItemStack owner) {
        super(4);
        this.owner = owner;
        this.loadRunes();
    }

    private void loadRunes() {
        if (this.owner.func_190926_b()) {
            return;
        }
        CompoundNBT nbt = this.owner.func_196082_o();
        if (nbt.func_74764_b("runesword")) {
            this.deserializeNBT(nbt.func_74775_l("runesword"));
        }
    }

    protected void onContentsChanged(int slot) {
        this.owner.func_196082_o().func_218657_a("runesword", (INBT)this.serializeNBT());
    }

    private Map<RuneItem, Set<ItemStack>> getRunesMap() {
        HashMap<RuneItem, Set<ItemStack>> runes = new HashMap<RuneItem, Set<ItemStack>>();
        for (int i = 1; i < 4; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            RuneItem rune = (RuneItem)stack.func_77973_b();
            if (runes.containsKey(rune)) {
                ((Set)runes.get(rune)).add(stack);
                continue;
            }
            HashSet<ItemStack> stacks = new HashSet<ItemStack>();
            stacks.add(stack);
            runes.put(rune, stacks);
        }
        return runes;
    }

    public void onAttack(PlayerEntity player, Entity target) {
        if (player.field_70170_p.field_72995_K || (double)player.func_184825_o(0.0f) < 0.9) {
            return;
        }
        for (Map.Entry<RuneItem, Set<ItemStack>> entry : this.getRunesMap().entrySet()) {
            entry.getKey().onAttack(this.owner, player, target, entry.getValue());
        }
        ItemStack major = this.getStackInSlot(0);
        if (!major.func_190926_b()) {
            ((RuneItem)major.func_77973_b()).onAttackMajor(this.owner, player, target, major);
        }
    }

    public void onKill(PlayerEntity player, LivingEntity entityLiving, DamageSource source) {
        for (Map.Entry<RuneItem, Set<ItemStack>> entry : this.getRunesMap().entrySet()) {
            entry.getKey().onKill(this.owner, player, entityLiving, source, entry.getValue());
        }
        ItemStack major = this.getStackInSlot(0);
        if (!major.func_190926_b()) {
            ((RuneItem)major.func_77973_b()).onKillMajor(this.owner, player, entityLiving, source, major);
        }
    }

    public void tick(PlayerEntity player) {
    }

    public float onHurt(PlayerEntity player, DamageSource source, float amount) {
        if (!player.field_70170_p.field_72995_K) {
            for (Map.Entry<RuneItem, Set<ItemStack>> entry : this.getRunesMap().entrySet()) {
                amount = entry.getKey().onHurt(this.owner, player, source, amount, entry.getValue());
            }
            ItemStack major = this.getStackInSlot(0);
            if (!major.func_190926_b()) {
                amount = ((RuneItem)major.func_77973_b()).onHurtMajor(this.owner, player, source, amount, major);
            }
        }
        return amount;
    }

    public void onRightClick(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        for (Map.Entry<RuneItem, Set<ItemStack>> entry : this.getRunesMap().entrySet()) {
            entry.getKey().onRightClick(this.owner, player, entry.getValue());
        }
        ItemStack major = this.getStackInSlot(0);
        if (!major.func_190926_b()) {
            ((RuneItem)major.func_77973_b()).onRightClickMajor(this.owner, player, major);
        }
    }

    public float onBreakSpeed(PlayerEntity player, BlockState state, BlockPos pos, float speed) {
        for (Map.Entry<RuneItem, Set<ItemStack>> entry : this.getRunesMap().entrySet()) {
            speed = entry.getKey().onBreakSpeed(this.owner, player, state, pos, speed, entry.getValue());
        }
        ItemStack major = this.getStackInSlot(0);
        if (!major.func_190926_b()) {
            speed = ((RuneItem)major.func_77973_b()).onBreakSpeedMajor(this.owner, player, state, pos, speed, major);
        }
        return speed;
    }

    public boolean onHarvestCheck(PlayerEntity player, BlockState state, boolean canHarvest) {
        ItemStack major = this.getStackInSlot(0);
        if (!major.func_190926_b()) {
            canHarvest = ((RuneItem)major.func_77973_b()).onHarvestCheckMajor(this.owner, player, state, canHarvest, major);
        }
        return canHarvest;
    }

    public void onBlockBreak(PlayerEntity player, BlockState state, BlockPos pos) {
        for (Map.Entry<RuneItem, Set<ItemStack>> entry : this.getRunesMap().entrySet()) {
            entry.getKey().onBlockBreak(this.owner, player, state, pos, entry.getValue());
        }
        ItemStack major = this.getStackInSlot(0);
        if (!major.func_190926_b()) {
            ((RuneItem)major.func_77973_b()).onBlockBreakMajor(this.owner, player, state, pos, major);
        }
    }

    public Collection<? extends ITextComponent> getTooltip() {
        ArrayList<IFormattableTextComponent> tooltip = new ArrayList<IFormattableTextComponent>();
        for (int i = 0; i < 4; ++i) {
            TranslationTextComponent prefix;
            ItemStack rune = this.getStackInSlot(i);
            TranslationTextComponent translationTextComponent = prefix = i == 0 ? new TranslationTextComponent("tooltip.runesword.major") : new TranslationTextComponent("tooltip.runesword.minor");
            if (rune.func_190926_b()) continue;
            IFormattableTextComponent text = new TranslationTextComponent(rune.func_77977_a()).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)((RuneItem)rune.func_77973_b()).getColor())));
            tooltip.add(prefix.func_230529_a_((ITextComponent)text));
        }
        return tooltip;
    }

    public boolean isSlotUnlocked(int slot) {
        int level = 4;
        if (this.owner.func_77973_b() instanceof TieredItem) {
            level = ((TieredItem)this.owner.func_77973_b()).func_200891_e().func_200925_d();
        }
        switch (slot) {
            case 1: {
                return level > 0;
            }
            case 2: {
                return level > 1;
            }
            case 3: {
                return level > 2;
            }
            case 0: {
                return level > 3;
            }
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof RuneItem)) {
            return false;
        }
        return this.isSlotUnlocked(slot);
    }

    public static boolean isRuneable(ItemStack stack) {
        return RunePowers.isAxe(stack) || RunePowers.isSword(stack);
    }

    public static LazyOptional<Runes> getRunes(ItemStack stack) {
        return stack.getCapability(CAPABILITY);
    }

    public static class Storage
    implements Capability.IStorage<Runes> {
        public INBT writeNBT(Capability<Runes> capability, Runes instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<Runes> capability, Runes instance, Direction side, INBT nbt) {
            instance.deserializeNBT((CompoundNBT)nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="runesword", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Provider
    implements ICapabilitySerializable<INBT> {
        private static final ResourceLocation SAVE_LOCATION = new ResourceLocation("runesword", "runes");
        private ItemStack owner;
        private LazyOptional<Runes> instance = LazyOptional.of(() -> new Runes(this.owner));

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
            if (Runes.isRuneable((ItemStack)event.getObject())) {
                event.addCapability(SAVE_LOCATION, (ICapabilityProvider)new Provider((ItemStack)event.getObject()));
            }
        }

        public Provider(ItemStack owner) {
            this.owner = owner;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public INBT serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null);
        }

        public void deserializeNBT(INBT nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null, nbt);
        }
    }
}

