/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.container;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.capability.Runes;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class RuneforgeContainer
extends Container {
    private IWorldPosCallable pos;
    public static final int[] RUNE_SLOTS_Y = new int[]{9, 35, 61, 35};
    public static final int[] RUNE_SLOTS_X = new int[]{80, 106, 80, 54};
    private Slot runeableSlot;
    private List<Slot> runeSlots;
    private WrapperRuneHandler runeHandler;

    public RuneforgeContainer(int id, PlayerInventory playerInv, PacketBuffer buffer) {
        this(id, playerInv, new ItemStackHandler(), IWorldPosCallable.field_221489_a);
    }

    public RuneforgeContainer(int id, PlayerInventory playerInv, ItemStackHandler runeableHandler, IWorldPosCallable pos) {
        super(Main.RUNEFORGE_CONTAINER, id);
        this.pos = pos;
        this.runeSlots = new ArrayList<Slot>();
        this.runeHandler = new WrapperRuneHandler();
        this.runeableSlot = this.func_75146_a((Slot)new SlotRuneableHandler((IItemHandler)runeableHandler, 0, 80, 35));
        this.updateRuneSlots();
        for (int i = 0; i < 4; ++i) {
            this.runeSlots.add(this.func_75146_a((Slot)new SlotRuneHandler(this.runeHandler, i, RUNE_SLOTS_X[i], RUNE_SLOTS_Y[i])));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, 8 + x * 18, 142));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return RuneforgeContainer.func_216963_a((IWorldPosCallable)this.pos, (PlayerEntity)playerIn, (Block)Main.RUNEFORGE_BLOCK);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        int playerInvEnd;
        int runeforgeEnd;
        int playerInvStart = runeforgeEnd = 5;
        int hotbarStart = playerInvEnd = playerInvStart + 27;
        int hotbarEnd = hotbarStart + 9;
        ItemStack copy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            copy = stack.func_77946_l();
            if (index < runeforgeEnd ? !this.func_75135_a(stack, 5, 39, false) : (index >= hotbarStart && index < hotbarEnd ? !this.func_75135_a(stack, 0, runeforgeEnd, false) && !this.func_75135_a(stack, playerInvStart, playerInvEnd, false) : index >= playerInvStart && index < playerInvEnd && !this.func_75135_a(stack, 0, runeforgeEnd, false) && !this.func_75135_a(stack, hotbarStart, hotbarEnd, false))) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == copy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return copy;
    }

    public ItemStack getRuneable() {
        return this.runeableSlot.func_75211_c();
    }

    private void updateRuneSlots() {
        LazyOptional<Runes> maybeRunes = Runes.getRunes(this.runeableSlot.func_75211_c());
        maybeRunes.ifPresent(runes -> this.runeHandler.enable(runes));
        if (!maybeRunes.isPresent()) {
            this.runeHandler.disable();
        }
    }

    private static class WrapperRuneHandler
    extends ItemStackHandler {
        private ItemStackHandler inner = new ItemStackHandler(4);
        private boolean disabled = true;

        private void enable(ItemStackHandler inner) {
            this.inner = inner;
            this.disabled = false;
        }

        private void disable() {
            this.disabled = true;
        }

        public void setSize(int size) {
            this.inner.setSize(size);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.inner.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.inner.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inner.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.inner.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inner.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.inner.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.inner.isItemValid(slot, stack) && !this.disabled;
        }

        public CompoundNBT serializeNBT() {
            return this.inner.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.inner.deserializeNBT(nbt);
        }
    }

    private static class SlotRuneHandler
    extends SlotItemHandler {
        private WrapperRuneHandler itemHandler;

        public SlotRuneHandler(WrapperRuneHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
            this.itemHandler = itemHandler;
        }

        public boolean func_111238_b() {
            return !this.itemHandler.disabled;
        }
    }

    private class SlotRuneableHandler
    extends SlotItemHandler {
        public SlotRuneableHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return super.func_75214_a(stack) && Runes.isRuneable(stack);
        }

        public void func_75218_e() {
            super.func_75218_e();
            RuneforgeContainer.this.updateRuneSlots();
        }
    }
}

