/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.entity;

import mod.vemerion.runesword.Main;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class FrostballEntity
extends SnowballEntity {
    public static final int SLOW_DURATION = 100;
    private int knockback;
    private int slowDuration = 100;

    public FrostballEntity(EntityType<? extends FrostballEntity> type, World world) {
        super(type, world);
    }

    public FrostballEntity(World world, LivingEntity shooter, int knockback, int slowDuration) {
        this(Main.FROSTBALL_ENTITY, world);
        this.func_212361_a((Entity)shooter);
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226280_cw_() - 0.1, shooter.func_226281_cx_());
        this.knockback = knockback;
        this.slowDuration = slowDuration;
    }

    public FrostballEntity(World world, LivingEntity shooter) {
        this(world, shooter, 0, 100);
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        super.func_213868_a(result);
        Entity entity = result.func_216348_a();
        Vector3d direction = this.func_213322_ci();
        entity.func_70024_g(direction.field_72450_a * 0.3 * (1.0 + (double)this.knockback * 0.1), 0.1, direction.field_72449_c * 0.3 * (1.0 + (double)this.knockback * 0.1));
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.func_195064_c(new EffectInstance(Effects.field_76421_d, this.slowDuration));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("duration")) {
            this.knockback = nbt.func_74762_e("knockback");
        }
        if (nbt.func_74764_b("slowDuration")) {
            this.slowDuration = nbt.func_74762_e("slowDuration");
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("knockback", this.knockback);
        nbt.func_74768_a("slowDuration", this.slowDuration);
        return nbt;
    }
}

