/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.entity;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.helpers.Helper;
import mod.vemerion.runesword.item.MagicRuneItem;
import mod.vemerion.runesword.particle.MagicBallParticleData;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class MagicBallEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    private static final int MAX_DURATION = 20;
    private int duration;
    private Map<Enchantment, Integer> enchantments;
    private Enchantment[] enchantmentArr;
    private boolean boomerang;
    private BlockPos startPos;

    public MagicBallEntity(EntityType<? extends MagicBallEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_70239_b(4.0);
        this.func_189654_d(true);
        this.enchantments = new HashMap<Enchantment, Integer>();
        this.enchantmentArr = new Enchantment[0];
        this.startPos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213869_a(Main.PROJECTILE_IMPACT_SOUND);
    }

    public MagicBallEntity(double x, double y, double z, World world, Map<Enchantment, Integer> enchantments) {
        super(Main.MAGIC_BALL_ENTITY, x, y, z, world);
        this.func_70239_b(4.0);
        this.func_189654_d(true);
        this.enchantments = enchantments;
        this.enchantmentArr = enchantments.keySet().toArray(new Enchantment[0]);
        this.boomerang = this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_203193_C) * 0.1;
        this.startPos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213869_a(Main.PROJECTILE_IMPACT_SOUND);
    }

    private int getEnchantmentLevel(Enchantment enchantment) {
        return this.enchantments.getOrDefault(enchantment, 0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.duration;
        if (!this.field_70170_p.field_72995_K) {
            if (this.duration > this.getDuration()) {
                this.func_70106_y();
            }
            if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_77329_d) * 0.01) {
                MagicRuneItem.leaveTrail(this.field_70170_p, this.func_233580_cy_(), Blocks.field_150480_ab.func_176223_P());
            }
            if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185301_j) * 0.03) {
                MagicRuneItem.leaveTrail(this.field_70170_p, this.func_233580_cy_(), Blocks.field_150433_aE.func_176223_P());
            }
            this.deflectProjectiles();
        } else {
            this.createParticles();
        }
        if (this.duration == this.getDuration() / 2 && this.boomerang) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(-1.0));
        }
    }

    private void deflectProjectiles() {
        int projectileProt = this.getEnchantmentLevel(Enchantments.field_180308_g);
        if (projectileProt <= 0) {
            return;
        }
        List projectiles = this.field_70170_p.func_175647_a(ProjectileEntity.class, this.func_174813_aQ().func_186662_g(1.0), e -> {
            if (e == this) {
                return false;
            }
            Entity shooter = this.func_234616_v_();
            Entity otherShooter = e.func_234616_v_();
            return shooter == null || otherShooter == null || shooter != otherShooter;
        });
        for (ProjectileEntity projectile : projectiles) {
            if (!(this.field_70146_Z.nextDouble() < (double)projectileProt * 0.01)) continue;
            projectile.func_70106_y();
        }
    }

    private int getDuration() {
        return 20 * (this.getEnchantmentLevel(Enchantments.field_185312_x) + 1);
    }

    protected float func_203044_p() {
        return 0.95f + (float)this.getEnchantmentLevel(Enchantments.field_185300_i) * 0.008f;
    }

    private void createParticles() {
        for (int i = 0; i < 10; ++i) {
            Color color = MagicRuneItem.getRandEnchColor(this.field_70146_Z, this.enchantmentArr);
            Vector3d pos = new Vector3d(this.func_226277_ct_() + this.randCoord(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f) + this.randCoord(), this.func_226281_cx_() + this.randCoord());
            this.field_70170_p.func_195594_a((IParticleData)new MagicBallParticleData((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    private double randCoord() {
        return (this.field_70146_Z.nextDouble() - 0.5) * 0.5;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("duration")) {
            this.duration = compound.func_74762_e("duration");
        }
        if (compound.func_74764_b("enchantments")) {
            this.initEnchantments(compound.func_150295_c("enchantments", 10));
        }
        if (compound.func_74764_b("boomerang")) {
            this.boomerang = compound.func_74767_n("boomerang");
        }
        if (compound.func_74764_b("startPos")) {
            this.startPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("startPos"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("duration", this.duration);
        compound.func_218657_a("enchantments", (INBT)MagicRuneItem.serializeEnchantments(this.enchantments));
        compound.func_74757_a("boomerang", this.boomerang);
        compound.func_218657_a("startPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.startPos));
    }

    private void initEnchantments(ListNBT list) {
        this.enchantments = MagicRuneItem.deserializeEnchantments(list);
        this.enchantmentArr = this.enchantments.keySet().toArray(new Enchantment[0]);
    }

    protected SoundEvent func_213867_k() {
        return Main.PROJECTILE_IMPACT_SOUND;
    }

    protected void func_70227_a(RayTraceResult result) {
        int lure;
        super.func_70227_a(result);
        Vector3d pos = result.func_216347_e();
        Entity shooter = this.func_234616_v_();
        if (!this.field_70170_p.field_72995_K) {
            Entity target;
            if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185297_d) * 0.05) {
                this.field_70170_p.func_217385_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 2.0f, Explosion.Mode.BREAK);
            }
            int sweeping = this.getEnchantmentLevel(Enchantments.field_191530_r);
            Entity entity = target = result.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)result).func_216348_a() : null;
            if (sweeping > 0) {
                DamageSource source = shooter == null ? Helper.magicDamage() : Helper.magicDamage((Entity)this, shooter);
                for (LivingEntity e2 : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g((double)sweeping * 0.2), e -> e != shooter && e != target)) {
                    e2.func_70097_a(source, 2.0f);
                }
            }
        }
        if ((lure = this.getEnchantmentLevel(Enchantments.field_151369_A)) > 0) {
            for (LivingEntity e3 : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g((double)lure * 0.2), e -> e != shooter)) {
                Vector3d direction = pos.func_178788_d(e3.func_213303_ch()).func_72432_b();
                e3.func_70024_g(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
            }
        }
        if (shooter != null && this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_203195_E)) {
            Vector3d direction = pos.func_178788_d(shooter.func_213303_ch()).func_72432_b();
            shooter.func_70024_g(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        this.func_70106_y();
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        this.func_184185_a(this.func_213867_k(), 1.0f, Helper.soundPitch(this.field_70146_Z));
        if (!this.field_70170_p.field_72995_K) {
            Entity target = result.func_216348_a();
            DamageSource source = Helper.magicDamage();
            if (this.func_234616_v_() != null && this.func_234616_v_() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)this.func_234616_v_();
                source = Helper.magicDamage((Entity)this, (Entity)player);
                int respiration = this.getEnchantmentLevel(Enchantments.field_185298_f);
                int air = player.func_70086_ai() + (int)((double)respiration * 0.34 * (double)((float)player.func_205010_bg() / 10.0f));
                player.func_70050_g(Math.min(player.func_205010_bg(), air));
                if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_203196_F) * 0.15) {
                    LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
                    lightning.func_233576_c_(Vector3d.func_237492_c_((Vector3i)target.func_233580_cy_()));
                    lightning.func_204809_d((ServerPlayerEntity)player);
                    this.field_70170_p.func_217376_c((Entity)lightning);
                }
                if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185296_A) * 0.33) {
                    player.func_70691_i(2.0f);
                }
                if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_180310_c) * 0.015) {
                    player.func_195064_c(new EffectInstance(Effects.field_76429_m, 200));
                }
            }
            if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185307_s) * 0.01) {
                source.func_76348_h();
            }
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_180309_e) * 0.015) {
                    living.func_195064_c(new EffectInstance(Effects.field_188424_y, 60));
                }
                if (this.field_70146_Z.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_92091_k) * 0.03) {
                    living.func_195064_c(new EffectInstance(Effects.field_76436_u, 140));
                }
            }
            MagicRuneItem.applyMagicDamage(target, source, (float)this.func_70242_d() + this.distanceDamage(), this.enchantments, this.field_70146_Z, 1.0f);
            if (!target.func_70089_S() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.spawnEgg(target);
                MagicRuneItem.bonusExp(this.field_70170_p, this.getEnchantmentLevel(Enchantments.field_185304_p), this.func_213303_ch());
            }
            if (this.field_70146_Z.nextDouble() < this.fireChance()) {
                target.func_70015_d(3);
            }
            MagicRuneItem.knockback(this.getEnchantmentLevel(Enchantments.field_180313_o), this.getEnchantmentLevel(Enchantments.field_185310_v), this.func_213322_ci(), target);
            if (this.field_70146_Z.nextDouble() >= (double)this.getEnchantmentLevel(Enchantments.field_222194_I) * 0.04) {
                this.func_70106_y();
            }
        }
    }

    private void spawnEgg(Entity target) {
        if (!target.func_184222_aU() || this.field_70146_Z.nextDouble() >= (double)this.getEnchantmentLevel(Enchantments.field_185306_r) * 0.01) {
            return;
        }
        SpawnEggItem egg = null;
        for (SpawnEggItem e : SpawnEggItem.func_195985_g()) {
            if (e.func_208076_b(null) != target.func_200600_R()) continue;
            egg = e;
            break;
        }
        if (egg != null) {
            ItemEntity eggEntity = new ItemEntity(this.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), new ItemStack((IItemProvider)egg));
            this.field_70170_p.func_217376_c((Entity)eggEntity);
        }
    }

    private double fireChance() {
        return (double)this.getEnchantmentLevel(Enchantments.field_77334_n) * 0.08 + (double)this.getEnchantmentLevel(Enchantments.field_185311_w) * 0.16;
    }

    private float distanceDamage() {
        int efficiency = this.getEnchantmentLevel(Enchantments.field_185305_q);
        return (float)efficiency / 15.0f * (float)this.func_213303_ch().func_72438_d(Vector3d.func_237489_a_((Vector3i)this.startPos)) * 0.3f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("enchantments", (INBT)MagicRuneItem.serializeEnchantments(this.enchantments));
        buffer.func_150786_a(compound);
        buffer.writeBoolean(this.boomerang);
        CompoundNBT shooterNBT = new CompoundNBT();
        Entity shooter = this.func_234616_v_();
        shooterNBT.func_74757_a("exists", shooter != null && shooter instanceof PlayerEntity);
        if (shooter != null) {
            shooterNBT.func_186854_a("uuid", shooter.func_110124_au());
        }
        buffer.func_150786_a(shooterNBT);
    }

    public void readSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = buffer.func_150793_b();
        ListNBT list = compound.func_150295_c("enchantments", 10);
        this.initEnchantments(list);
        this.boomerang = buffer.readBoolean();
        CompoundNBT shooterNBT = buffer.func_150793_b();
        if (shooterNBT.func_74767_n("exists")) {
            this.func_212361_a((Entity)this.field_70170_p.func_217371_b(shooterNBT.func_186857_a("uuid")));
        }
    }
}

