/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.guide;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import mod.vemerion.runesword.api.IGuideChapter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GuideChapter
implements IGuideChapter {
    private static final int ICON_SIZE = 16;
    private static final int COMPONENT_PADDING = 6;
    private IItemProvider itemIcon;
    private ResourceLocation rlIcon;
    private HeaderComponent title;
    private List<GuideChapter> children = new ArrayList<GuideChapter>();
    private List<ChapterComponent> components = new ArrayList<ChapterComponent>();

    public GuideChapter(IItemProvider icon, ITextComponent title) {
        this.itemIcon = icon;
        this.title = new HeaderComponent(title);
    }

    public GuideChapter(ResourceLocation icon, ITextComponent title) {
        this.rlIcon = icon;
        this.title = new HeaderComponent(title);
    }

    public static void throwIfInvalidChapter(IGuideChapter chapter) {
        if (!(chapter instanceof GuideChapter)) {
            throw new IllegalArgumentException("openGuide() parameter is not of type GuideChapter");
        }
    }

    @Override
    public GuideChapter addChild(IGuideChapter child) {
        GuideChapter.throwIfInvalidChapter(child);
        this.children.add((GuideChapter)child);
        return this;
    }

    @Override
    public GuideChapter addText(String translationKey) {
        this.components.add(new TextComponent((ITextComponent)new TranslationTextComponent(translationKey)));
        return this;
    }

    @Override
    public GuideChapter addHeader(String translationKey) {
        this.components.add(new HeaderComponent((ITextComponent)new TranslationTextComponent(translationKey)));
        return this;
    }

    @Override
    public GuideChapter addImage(ResourceLocation image, int imgWidth, int imgHeight) {
        this.components.add(new ImageComponent(image, imgWidth, imgHeight));
        return this;
    }

    public ITextComponent getTitle() {
        return this.title.text;
    }

    public void renderTitle(MatrixStack matrix, Minecraft mc, int x, int y, int width, int height) {
        this.title.render(matrix, mc, x, y, y, width, height);
    }

    public boolean mouseClicked(int x, int y, int top, int width, int height, double mouseX, double mouseY, int button, Consumer<GuideChapter> changeChapter) {
        int left = x;
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.isInside(x, y, 16, mouseX, mouseY) && button == 0 && GuideChapter.isInsideScreen(y, 16, top, height)) {
                changeChapter.accept(this.children.get(i));
                return true;
            }
            if ((x += 16) + 16 <= left + width || i + 1 == this.children.size()) continue;
            x = left;
            y += 16;
        }
        return false;
    }

    public int renderComponents(MatrixStack matrix, Minecraft mc, int x, int y, int top, int width, int height, int mouseX, int mouseY) {
        int left = x;
        for (int i = 0; i < this.children.size(); ++i) {
            GuideChapter c = this.children.get(i);
            if (GuideChapter.isInsideScreen(y, 16, top, height)) {
                c.renderIcon(matrix, mc, x, y, width, height, mouseX, mouseY);
            }
            if ((x += 16) + 16 <= left + width || i + 1 == this.children.size()) continue;
            x = left;
            y += 16;
        }
        x = left;
        y += this.children.isEmpty() ? 6 : 22;
        for (ChapterComponent comp : this.components) {
            y = comp.render(matrix, mc, x, y, top, width, height) + 6;
        }
        return y;
    }

    private void renderIcon(MatrixStack matrix, Minecraft mc, int x, int y, int width, int height, int mouseX, int mouseY) {
        if (this.isInside(x, y, 16, mouseX, mouseY)) {
            GuiUtils.drawHoveringText((MatrixStack)matrix, Arrays.asList(this.title.text), (int)mouseX, (int)mouseY, (int)width, (int)height, (int)-1, (FontRenderer)mc.field_71466_p);
        }
        if (this.itemIcon != null) {
            mc.func_175599_af().func_180450_b(new ItemStack(this.itemIcon), x, y);
        } else {
            mc.func_110434_K().func_110577_a(this.rlIcon);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    private boolean isInside(int left, int top, int size, double x, double y) {
        return x > (double)left && x < (double)(left + size) && y > (double)top && y < (double)(top + size);
    }

    private static boolean isInsideScreen(int y, int size, int top, int height) {
        return y >= top && y + size < top + height;
    }

    private static class ImageComponent
    implements ChapterComponent {
        private static final float SCALE = 0.6f;
        private ResourceLocation image;
        private int imgWidth;
        private int imgHeight;

        private ImageComponent(ResourceLocation image, int imgWidth, int imgHeight) {
            this.image = image;
            this.imgWidth = imgWidth;
            this.imgHeight = imgHeight;
        }

        @Override
        public int render(MatrixStack matrix, Minecraft mc, int x, int y, int top, int width, int height) {
            float ratio;
            mc.func_110434_K().func_110577_a(this.image);
            float scale = (float)width / (float)this.imgWidth * 0.6f;
            int drawWidth = (int)((float)this.imgWidth * scale);
            int drawHeight = (int)((float)this.imgHeight * scale);
            int offset = drawHeight + 2;
            if (y + drawHeight <= top || y >= top + height) {
                return y + offset;
            }
            int vHeight = this.imgHeight;
            int v = 0;
            int drawY = y;
            if (y < top && y + drawHeight > top) {
                ratio = (float)(y + drawHeight - top) / (float)drawHeight;
                v = (int)((float)v + (float)this.imgHeight * (1.0f - ratio));
                drawY = (int)((float)drawY + (float)drawHeight * (1.0f - ratio));
                vHeight = (int)(ratio * (float)vHeight);
                drawHeight = (int)(ratio * (float)drawHeight);
            }
            if (y + drawHeight > top + height) {
                ratio = 1.0f - (float)(y + drawHeight - (top + height)) / (float)drawHeight;
                drawHeight = (int)((float)drawHeight * ratio);
                vHeight = (int)((float)vHeight * ratio);
            }
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x + width / 2 - drawWidth / 2), (int)drawY, (int)drawWidth, (int)drawHeight, (float)0.0f, (float)v, (int)this.imgWidth, (int)vHeight, (int)this.imgWidth, (int)this.imgHeight);
            return y + offset;
        }
    }

    private static class HeaderComponent
    implements ChapterComponent {
        private static final int COLOR = Color.BLACK.getRGB();
        private static final float SCALE = 1.3f;
        private ITextComponent text;

        private HeaderComponent(ITextComponent text) {
            this.text = text;
        }

        @Override
        public int render(MatrixStack matrix, Minecraft mc, int x, int y, int top, int width, int height) {
            FontRenderer font = mc.field_71466_p;
            List lines = font.func_238425_b_((ITextProperties)this.text, (int)((float)width / 1.3f));
            for (IReorderingProcessor line : lines) {
                float textWidth = (float)font.func_243245_a(line) * 1.3f;
                matrix.func_227860_a_();
                matrix.func_227862_a_(1.3f, 1.3f, 1.0f);
                font.getClass();
                if (GuideChapter.isInsideScreen(y, (int)(9.0f * 1.3f), top, height)) {
                    font.func_238422_b_(matrix, line, ((float)(x + width / 2) - textWidth / 2.0f) / 1.3f, (float)y / 1.3f, COLOR);
                }
                float f = y;
                font.getClass();
                y = (int)(f + 9.0f * 1.3f);
                matrix.func_227865_b_();
            }
            return y + 2;
        }
    }

    private static class TextComponent
    implements ChapterComponent {
        private static final int COLOR = Color.BLACK.getRGB();
        private ITextComponent text;

        private TextComponent(ITextComponent text) {
            this.text = text;
        }

        @Override
        public int render(MatrixStack matrix, Minecraft mc, int x, int y, int top, int width, int height) {
            FontRenderer font = mc.field_71466_p;
            List lines = font.func_238425_b_((ITextProperties)this.text, width);
            for (IReorderingProcessor line : lines) {
                font.getClass();
                if (GuideChapter.isInsideScreen(y, 9, top, height)) {
                    font.func_238422_b_(matrix, line, (float)x, (float)y, COLOR);
                }
                font.getClass();
                y += 9;
            }
            return y;
        }
    }

    private static interface ChapterComponent {
        public int render(MatrixStack var1, Minecraft var2, int var3, int var4, int var5, int var6, int var7);
    }
}

