/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.guide;

import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.api.IGuide;
import mod.vemerion.runesword.api.IGuideChapter;
import mod.vemerion.runesword.api.RuneswordAPI;
import mod.vemerion.runesword.item.RuneItem;
import net.minecraft.block.Blocks;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuideChapters {
    private static IGuideChapter runeforge;
    private static IGuideChapter enchant;
    private static IGuideChapter blood;
    private static IGuideChapter air;
    private static IGuideChapter earth;
    private static IGuideChapter water;
    private static IGuideChapter fire;
    private static IGuideChapter frost;
    private static IGuideChapter magic;
    private static IGuideChapter start;
    private static IGuideChapter bloodSword;
    private static IGuideChapter airSword;
    private static IGuideChapter earthSword;
    private static IGuideChapter waterSword;
    private static IGuideChapter fireSword;
    private static IGuideChapter frostSword;
    private static IGuideChapter magicSword;
    private static IGuideChapter bloodAxe;
    private static IGuideChapter airAxe;
    private static IGuideChapter earthAxe;
    private static IGuideChapter waterAxe;
    private static IGuideChapter fireAxe;
    private static IGuideChapter frostAxe;
    private static IGuideChapter magicAxe;

    public static IGuideChapter getStartChapter() {
        if (start == null) {
            TranslationTextComponent swordPowers = new TranslationTextComponent(GuideChapters.transKey("swordpowers"));
            TranslationTextComponent axePowers = new TranslationTextComponent(GuideChapters.transKey("axepowers"));
            IGuide guide = RuneswordAPI.guide;
            runeforge = guide.createGuideChapter((IItemProvider)Main.RUNEFORGE_BLOCK, (ITextComponent)Main.RUNEFORGE_BLOCK.func_235333_g_());
            enchant = guide.createGuideChapter((IItemProvider)Blocks.field_150381_bn, (ITextComponent)new TranslationTextComponent(GuideChapters.transKey("enchanting")));
            blood = guide.createGuideChapter((IItemProvider)RuneItem.BLOOD_RUNE_ITEM, RuneItem.BLOOD_RUNE_ITEM.func_200296_o());
            air = guide.createGuideChapter((IItemProvider)RuneItem.AIR_RUNE_ITEM, RuneItem.AIR_RUNE_ITEM.func_200296_o());
            earth = guide.createGuideChapter((IItemProvider)RuneItem.EARTH_RUNE_ITEM, RuneItem.EARTH_RUNE_ITEM.func_200296_o());
            water = guide.createGuideChapter((IItemProvider)RuneItem.WATER_RUNE_ITEM, RuneItem.WATER_RUNE_ITEM.func_200296_o());
            fire = guide.createGuideChapter((IItemProvider)RuneItem.FIRE_RUNE_ITEM, RuneItem.FIRE_RUNE_ITEM.func_200296_o());
            frost = guide.createGuideChapter((IItemProvider)RuneItem.FROST_RUNE_ITEM, RuneItem.FROST_RUNE_ITEM.func_200296_o());
            magic = guide.createGuideChapter((IItemProvider)RuneItem.MAGIC_RUNE_ITEM, RuneItem.MAGIC_RUNE_ITEM.func_200296_o());
            start = guide.createGuideChapter((IItemProvider)Main.GUIDE_ITEM, (ITextComponent)new TranslationTextComponent(GuideChapters.transKey("guide")));
            bloodSword = guide.createGuideChapter((IItemProvider)Items.field_234754_kI_, (ITextComponent)swordPowers);
            airSword = guide.createGuideChapter((IItemProvider)Items.field_234754_kI_, (ITextComponent)swordPowers);
            earthSword = guide.createGuideChapter((IItemProvider)Items.field_234754_kI_, (ITextComponent)swordPowers);
            waterSword = guide.createGuideChapter((IItemProvider)Items.field_234754_kI_, (ITextComponent)swordPowers);
            fireSword = guide.createGuideChapter((IItemProvider)Items.field_234754_kI_, (ITextComponent)swordPowers);
            frostSword = guide.createGuideChapter((IItemProvider)Items.field_234754_kI_, (ITextComponent)swordPowers);
            magicSword = guide.createGuideChapter((IItemProvider)Items.field_234754_kI_, (ITextComponent)swordPowers);
            bloodAxe = guide.createGuideChapter((IItemProvider)Items.field_234757_kL_, (ITextComponent)axePowers);
            airAxe = guide.createGuideChapter((IItemProvider)Items.field_234757_kL_, (ITextComponent)axePowers);
            earthAxe = guide.createGuideChapter((IItemProvider)Items.field_234757_kL_, (ITextComponent)axePowers);
            waterAxe = guide.createGuideChapter((IItemProvider)Items.field_234757_kL_, (ITextComponent)axePowers);
            fireAxe = guide.createGuideChapter((IItemProvider)Items.field_234757_kL_, (ITextComponent)axePowers);
            frostAxe = guide.createGuideChapter((IItemProvider)Items.field_234757_kL_, (ITextComponent)axePowers);
            magicAxe = guide.createGuideChapter((IItemProvider)Items.field_234757_kL_, (ITextComponent)axePowers);
            runeforge.addText(GuideChapters.transKey("runeforge1")).addImage(GuideChapters.image("runeforge_crafting"), 518, 265).addText(GuideChapters.transKey("runeforge2")).addImage(GuideChapters.image("runeforge"), 176, 166).addText(GuideChapters.transKey("runeforge3")).addText(GuideChapters.transKey("runeforge4"));
            enchant.addText(GuideChapters.transKey("enchantingtext"));
            blood.addChild(bloodSword).addChild(bloodAxe).addText(GuideChapters.transKey("blood.obtain"));
            GuideChapters.powers(bloodSword, "blood.sword", 3, 2);
            GuideChapters.powers(bloodAxe, "blood.axe", 3, 2);
            air.addChild(airSword).addChild(airAxe).addText(GuideChapters.transKey("air.obtain"));
            GuideChapters.powers(airSword, "air.sword", 2, 3);
            GuideChapters.powers(airAxe, "air.axe", 3, 2);
            earth.addChild(earthSword).addChild(earthAxe).addText(GuideChapters.transKey("earth.obtain"));
            GuideChapters.powers(earthSword, "earth.sword", 3, 2);
            GuideChapters.powers(earthAxe, "earth.axe", 3, 2);
            water.addChild(waterSword).addChild(waterAxe).addText(GuideChapters.transKey("water.obtain"));
            GuideChapters.powers(waterSword, "water.sword", 2, 3);
            GuideChapters.powers(waterAxe, "water.axe", 3, 2);
            fire.addChild(fireSword).addChild(fireAxe).addText(GuideChapters.transKey("fire.obtain"));
            GuideChapters.powers(fireSword, "fire.sword", 3, 2);
            GuideChapters.powers(fireAxe, "fire.axe", 3, 2);
            frost.addChild(frostSword).addChild(frostAxe).addText(GuideChapters.transKey("frost.obtain"));
            GuideChapters.powers(frostSword, "frost.sword", 3, 3);
            GuideChapters.powers(frostAxe, "frost.axe", 2, 4);
            magic.addChild(magicSword).addChild(magicAxe).addText(GuideChapters.transKey("magic.obtain")).addText(GuideChapters.transKey("magic.text"));
            GuideChapters.powers(magicSword, "magic.sword", 36, 0);
            GuideChapters.powers(magicAxe, "magic.axe", 36, 0);
            start.addChild(runeforge).addChild(enchant).addChild(blood).addChild(air).addChild(earth).addChild(water).addChild(fire).addChild(frost).addChild(magic).addText(GuideChapters.transKey("intro"));
        }
        return start;
    }

    private static void powers(IGuideChapter chapter, String prefix, int minorEnchants, int majorEnchants) {
        int i;
        chapter.addText(GuideChapters.transKey(prefix + ".minor")).addText(GuideChapters.transKey(prefix + ".major"));
        if (minorEnchants > 0) {
            chapter.addHeader(GuideChapters.transKey("minorenchants"));
            for (i = 1; i <= minorEnchants; ++i) {
                chapter.addText(GuideChapters.transKey(prefix + ".minorenchant" + i));
            }
        }
        if (majorEnchants > 0) {
            chapter.addHeader(GuideChapters.transKey("majorenchants"));
            for (i = 1; i <= majorEnchants; ++i) {
                chapter.addText(GuideChapters.transKey(prefix + ".majorenchant" + i));
            }
        }
    }

    private static String transKey(String suffix) {
        return GuideChapters.transKey("gui", suffix);
    }

    private static String transKey(String prefix, String suffix) {
        return prefix + "." + "runesword" + "." + suffix;
    }

    private static ResourceLocation image(String name) {
        return new ResourceLocation("runesword", "textures/guide/" + name + ".png");
    }
}

