/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.item.RunePowers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;

public class AirRuneItem
extends RuneItem {
    public AirRuneItem(Item.Properties properties) {
        super(new Color(170, 220, 220).getRGB(), (List<RunePowers>)ImmutableList.of((Object)new SwordPowers(), (Object)new AxePowers()), properties);
    }

    private static class SwordPowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_185312_x, (Object)Enchantments.field_180309_e, (Object)Enchantments.field_185305_q, (Object)Enchantments.field_185310_v, (Object)Enchantments.field_180313_o);

        private SwordPowers() {
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return SwordPowers.isSword(stack);
        }

        @Override
        public void onAttack(ItemStack sword, PlayerEntity player, Entity target, Set<ItemStack> runes) {
            if (player.func_70681_au().nextDouble() < (double)runes.size() * 0.1) {
                Vector3d direction = Vector3d.func_189984_a((Vector2f)player.func_189653_aC()).func_186678_a((double)this.getEnchantmentLevel(Enchantments.field_180313_o, runes) * 0.1);
                target.func_70024_g(direction.field_72450_a, 0.8 + (double)this.getEnchantmentLevel(Enchantments.field_185310_v, runes) * 0.03, direction.field_72449_c);
                target.func_230245_c_(false);
            }
        }

        @Override
        public void onKillMajor(ItemStack sword, PlayerEntity player, LivingEntity entityLiving, DamageSource source, ItemStack rune) {
            int duration = 200;
            int level = 0;
            if (this.getEnchantmentLevel(Enchantments.field_185312_x, rune) > 0) {
                duration *= 2;
            }
            if (player.func_70681_au().nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185305_q, rune) * 0.8) {
                level = 1;
            }
            player.func_195064_c(new EffectInstance(Effects.field_76424_c, duration, level));
            if (player.func_70681_au().nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_180309_e, rune) * 0.1) {
                player.func_195064_c(new EffectInstance(Effects.field_76430_j, duration, level));
            }
        }
    }

    public static class AxePowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_185306_r, (Object)Enchantments.field_185305_q, (Object)Enchantments.field_180309_e, (Object)Enchantments.field_185308_t, (Object)Enchantments.field_185312_x);

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return AxePowers.isAxe(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public float onBreakSpeed(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, float speed, Set<ItemStack> runes) {
            boolean hasSilkTouch;
            boolean isLeave = state.func_235714_a_((ITag)BlockTags.field_206952_E);
            boolean bl = hasSilkTouch = this.getEnchantmentLevel(Enchantments.field_185306_r, runes) > 0;
            if (runeable.getToolTypes().contains(state.getHarvestTool()) || isLeave && hasSilkTouch) {
                if (!player.func_233570_aj_()) {
                    speed += (float)(7 + this.getEnchantmentLevel(Enchantments.field_185305_q, runes));
                }
                if (player.func_70644_a(Effects.field_188424_y)) {
                    speed += (float)this.getEnchantmentLevel(Enchantments.field_180309_e, runes);
                }
            }
            return speed;
        }

        @Override
        public void onBlockBreakMajor(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, ItemStack rune) {
            if (runeable.getToolTypes().contains(state.getHarvestTool()) && field_77697_d.nextDouble() < 0.2 + (double)this.getEnchantmentLevel(Enchantments.field_185308_t, rune) * 0.1) {
                int duration = 200;
                if (this.getEnchantmentLevel(Enchantments.field_185312_x, rune) > 0) {
                    duration *= 2;
                }
                player.func_195064_c(new EffectInstance(Effects.field_188424_y, duration, 0));
            }
        }
    }
}

