/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.item.RunePowers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;

public class BloodRuneItem
extends RuneItem {
    public BloodRuneItem(Item.Properties properties) {
        super(new Color(210, 20, 20).getRGB(), (List<RunePowers>)ImmutableList.of((Object)new SwordPowers(), (Object)new AxePowers()), properties);
    }

    private static class SwordPowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_180310_c, (Object)Enchantments.field_185302_k, (Object)Enchantments.field_185296_A, (Object)Enchantments.field_77334_n, (Object)Enchantments.field_185299_g);

        private SwordPowers() {
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return SwordPowers.isSword(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public void onAttackMajor(ItemStack sword, PlayerEntity player, Entity target, ItemStack rune) {
            float damage = 4.0f + (float)this.getEnchantmentLevel(Enchantments.field_185302_k, rune) * 0.2f;
            target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), damage);
            if (!(player.func_70681_au().nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_180310_c, rune) * 0.05)) {
                player.func_70097_a(DamageSource.field_76376_m, 2.0f);
            }
            target.field_70172_ad = 0;
        }

        @Override
        public void onKill(ItemStack sword, PlayerEntity player, LivingEntity entityLiving, DamageSource source, Set<ItemStack> runes) {
            if (player.func_70681_au().nextDouble() < (double)runes.size() * 0.05) {
                float heal = 2.0f;
                if (entityLiving.func_223314_ad() > 0) {
                    heal += (float)this.getEnchantmentLevel(Enchantments.field_77334_n, runes) * 0.5f;
                }
                if (player.func_70090_H()) {
                    heal += (float)this.getEnchantmentLevel(Enchantments.field_185299_g, runes);
                }
                player.func_70691_i(heal);
                this.mendItem(sword, this.getEnchantmentLevel(Enchantments.field_185296_A, runes));
            }
        }
    }

    public static class AxePowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_185308_t, (Object)Enchantments.field_185312_x, (Object)Enchantments.field_185309_u, (Object)Enchantments.field_185302_k, (Object)Enchantments.field_203193_C);
        private static final int BASE_DURATION = 120;
        private static final int INF_DURATION = 40;

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return AxePowers.isAxe(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public void onAttack(ItemStack runeable, PlayerEntity player, Entity target, Set<ItemStack> runes) {
            int fortune = this.getEnchantmentLevel(Enchantments.field_185308_t, runes);
            if (target instanceof LivingEntity && field_77697_d.nextDouble() < (double)runes.size() * 0.1 + (double)fortune * 0.03) {
                int duration = 120 + this.getEnchantmentLevel(Enchantments.field_185312_x, runes) * 40;
                int level = field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185309_u, runes) * 0.01 ? 1 : 0;
                ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)Main.BLEED_EFFECT, duration, level, false, false, true));
            }
        }

        @Override
        public void onAttackMajor(ItemStack runeable, PlayerEntity player, Entity target, ItemStack rune) {
            if (target instanceof LivingEntity && ((LivingEntity)target).func_70644_a((Effect)Main.BLEED_EFFECT)) {
                float damage = 4.0f + (float)this.getEnchantmentLevel(Enchantments.field_185302_k, rune) * 0.5f;
                this.attack(player, target, damage);
                if (field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_203193_C, rune) * 0.1) {
                    player.func_70691_i(0.5f);
                }
            }
        }
    }
}

