/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.item.RunePowers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class EarthRuneItem
extends RuneItem {
    public EarthRuneItem(Item.Properties properties) {
        super(new Color(100, 50, 0).getRGB(), (List<RunePowers>)ImmutableList.of((Object)new SwordPowers(), (Object)new AxePowers()), properties);
    }

    private static class SwordPowers
    extends RunePowers {
        private static final List<Item> DROPS = ImmutableList.of((Object)Items.field_221552_E, (Object)Items.field_221553_F);
        private static final List<Item> LOOTING_DROPS = ImmutableList.of((Object)Items.field_221730_ca, (Object)Items.field_221551_D, (Object)Items.field_221733_dC);
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_185308_t, (Object)Enchantments.field_77334_n, (Object)Enchantments.field_185304_p, (Object)Enchantments.field_185302_k, (Object)Enchantments.field_180310_c);

        private SwordPowers() {
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return SwordPowers.isSword(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public float onHurtMajor(ItemStack sword, PlayerEntity player, DamageSource source, float amount, ItemStack rune) {
            if (player.func_226278_cu_() < 30.0 && !source.func_76363_c()) {
                amount *= 1.0f - 0.05f * (float)this.getEnchantmentLevel(Enchantments.field_180310_c, rune);
            }
            return amount;
        }

        @Override
        public void onAttackMajor(ItemStack sword, PlayerEntity player, Entity target, ItemStack rune) {
            if (player.func_226278_cu_() < 30.0) {
                float damage = 3.0f + (float)this.getEnchantmentLevel(Enchantments.field_185302_k, rune) * 0.2f;
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), damage);
                target.field_70172_ad = 0;
            }
        }

        @Override
        public void onKill(ItemStack sword, PlayerEntity player, LivingEntity entityLiving, DamageSource source, Set<ItemStack> runes) {
            if (player.func_70681_au().nextDouble() < (double)runes.size() * 0.1 + (double)this.getEnchantmentLevel(Enchantments.field_185308_t, runes) * 0.02) {
                ItemEntity dirt = new ItemEntity(player.field_70170_p, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), this.getDrop(player, runes));
                player.field_70170_p.func_217376_c((Entity)dirt);
            }
        }

        private ItemStack getDrop(PlayerEntity player, Set<ItemStack> runes) {
            World world = player.field_70170_p;
            ItemStack drop = new ItemStack((IItemProvider)DROPS.get(field_77697_d.nextInt(DROPS.size())));
            if (field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185304_p, runes) * 0.01) {
                drop = new ItemStack((IItemProvider)LOOTING_DROPS.get(field_77697_d.nextInt(LOOTING_DROPS.size())));
            }
            if (field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_77334_n, runes) * 0.05) {
                Inventory inv = new Inventory(new ItemStack[]{drop});
                Optional<ItemStack> smelted = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, world).map(arg_0 -> SwordPowers.lambda$getDrop$0((IInventory)inv, arg_0));
                if (smelted.isPresent()) {
                    drop = smelted.get();
                }
            }
            return drop;
        }

        private static /* synthetic */ ItemStack lambda$getDrop$0(IInventory inv, FurnaceRecipe r) {
            return r.func_77572_b(inv);
        }
    }

    private static class AxePowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_185308_t, (Object)Enchantments.field_185296_A, (Object)Enchantments.field_185305_q, (Object)Enchantments.field_185311_w, (Object)Enchantments.field_77334_n);

        private AxePowers() {
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return AxePowers.isAxe(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public float onBreakSpeed(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, float speed, Set<ItemStack> runes) {
            if (state.getHarvestTool() == ToolType.PICKAXE) {
                speed += (float)runes.size();
                speed += (float)this.getEnchantmentLevel(Enchantments.field_185305_q, runes);
                if (player.field_70170_p.func_234923_W_() == World.field_234919_h_) {
                    speed += (float)(this.getEnchantmentLevel(Enchantments.field_185311_w, runes) * 3);
                }
                if (player.func_223314_ad() > 0) {
                    speed += (float)(this.getEnchantmentLevel(Enchantments.field_77334_n, runes) * 2);
                }
            }
            return speed;
        }

        @Override
        public boolean onHarvestCheckMajor(ItemStack runeable, PlayerEntity player, BlockState state, boolean canHarvest, ItemStack rune) {
            return canHarvest || state.getHarvestTool() == ToolType.PICKAXE;
        }

        @Override
        public void onBlockBreakMajor(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, ItemStack rune) {
            if (this.getEnchantmentLevel(Enchantments.field_185296_A, rune) > 0 && field_77697_d.nextDouble() < 0.3) {
                this.mendItem(runeable, 2);
            }
            if (state.func_177230_c() == Blocks.field_150348_b && !player.func_184812_l_() && field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185308_t, rune) * 0.2) {
                this.spawnItem(player.field_70170_p, pos, Blocks.field_150347_e.func_199767_j().func_190903_i());
            }
        }
    }
}

