/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.item.RunePowers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FireRuneItem
extends RuneItem {
    public FireRuneItem(Item.Properties properties) {
        super(new Color(255, 100, 0).getRGB(), (List<RunePowers>)ImmutableList.of((Object)new SwordPowers(), (Object)new AxePowers()), properties);
    }

    private static class SwordPowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_77329_d, (Object)Enchantments.field_77334_n, (Object)Enchantments.field_185311_w, (Object)Enchantments.field_185309_u, (Object)Enchantments.field_185296_A);

        private SwordPowers() {
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return SwordPowers.isSword(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public void onAttackMajor(ItemStack sword, PlayerEntity player, Entity target, ItemStack rune) {
            if (player.func_223314_ad() > 0) {
                float damage = 4.0f + (float)this.getEnchantmentLevel(Enchantments.field_77334_n, rune) * 0.5f;
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), damage);
                target.field_70172_ad = 0;
            }
        }

        @Override
        public float onHurtMajor(ItemStack sword, PlayerEntity player, DamageSource source, float amount, ItemStack rune) {
            if (source.func_76347_k() && player.func_70681_au().nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_77329_d, rune) * 0.05) {
                amount = 0.0f;
            }
            return amount;
        }

        @Override
        public void onAttack(ItemStack sword, PlayerEntity player, Entity target, Set<ItemStack> runes) {
            BlockPos targetPos;
            if (player.func_70681_au().nextDouble() < (double)runes.size() * 0.1 + (double)this.getEnchantmentLevel(Enchantments.field_185311_w, runes) * 0.05 && player.field_70170_p.func_175623_d(targetPos = target.func_233580_cy_())) {
                BlockState fire = Blocks.field_150480_ab.func_176223_P();
                if (player.func_70681_au().nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185309_u, runes) * 0.01) {
                    fire = Blocks.field_150353_l.func_176223_P();
                }
                player.field_70170_p.func_175656_a(targetPos, fire);
            }
            if (target.func_223314_ad() > 0) {
                sword.func_196085_b(sword.func_77952_i() - this.getEnchantmentLevel(Enchantments.field_185296_A, runes));
            }
        }
    }

    public static class AxePowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_77334_n, (Object)Enchantments.field_185311_w, (Object)Enchantments.field_185299_g, (Object)Enchantments.field_185305_q, (Object)Enchantments.field_185302_k);

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return AxePowers.isAxe(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public float onBreakSpeed(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, float speed, Set<ItemStack> runes) {
            if (this.isCorrectTool(runeable, state)) {
                speed += (float)(runes.size() * 4);
                speed += (float)(this.getEnchantmentLevel(Enchantments.field_77334_n, runes) * 2);
                if (player.func_70027_ad()) {
                    speed += (float)(this.getEnchantmentLevel(Enchantments.field_185311_w, runes) * 4);
                }
            }
            return speed;
        }

        @Override
        public void onBlockBreak(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, Set<ItemStack> runes) {
            if (!this.isCorrectTool(runeable, state)) {
                return;
            }
            if (field_77697_d.nextDouble() < (double)runes.size() * 0.1 + (double)this.getEnchantmentLevel(Enchantments.field_77334_n, runes) * 0.5 - (double)this.getEnchantmentLevel(Enchantments.field_185299_g, runes) * 0.5) {
                player.func_70015_d(4);
            }
        }

        @Override
        public boolean onHarvestCheckMajor(ItemStack runeable, PlayerEntity player, BlockState state, boolean canHarvest, ItemStack rune) {
            return canHarvest && player.field_70170_p.func_234923_W_() == World.field_234919_h_;
        }

        @Override
        public float onBreakSpeedMajor(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, float speed, ItemStack rune) {
            if (player.field_70170_p.func_234923_W_() == World.field_234919_h_ && this.isCorrectTool(runeable, state)) {
                speed += 20.0f;
                speed += (float)this.getEnchantmentLevel(Enchantments.field_185305_q, rune);
            }
            return speed;
        }

        @Override
        public void onAttackMajor(ItemStack runeable, PlayerEntity player, Entity target, ItemStack rune) {
            int sharpness;
            EntityType type = target.func_200600_R();
            if ((type == EntityType.field_233591_ai_ || type == EntityType.field_233588_G_) && (sharpness = this.getEnchantmentLevel(Enchantments.field_185302_k, rune)) > 0) {
                this.attack(player, target, (float)sharpness * 0.5f);
            }
        }
    }
}

