/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.entity.FrostGolemEntity;
import mod.vemerion.runesword.entity.FrostballEntity;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.item.RunePowers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class FrostRuneItem
extends RuneItem {
    public FrostRuneItem(Item.Properties properties) {
        super(new Color(40, 120, 150).getRGB(), (List<RunePowers>)ImmutableList.of((Object)new SwordPowers(), (Object)new AxePowers()), properties);
    }

    private static class SwordPowers
    extends RunePowers {
        private static final int MAX_DURATION = 600;
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_185308_t, (Object)Enchantments.field_185312_x, (Object)Enchantments.field_185305_q, (Object)Enchantments.field_222192_G, (Object)Enchantments.field_180313_o, (Object)Enchantments.field_203196_F, (Object[])new Enchantment[0]);

        private SwordPowers() {
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return SwordPowers.isSword(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public void onKillMajor(ItemStack sword, PlayerEntity player, LivingEntity entityLiving, DamageSource source, ItemStack rune) {
            if (player.func_70681_au().nextDouble() < 0.1 + (double)this.getEnchantmentLevel(Enchantments.field_185308_t, rune) * 0.05) {
                int duration = 600;
                if (this.getEnchantmentLevel(Enchantments.field_185312_x, rune) > 0) {
                    duration *= 2;
                }
                FrostGolemEntity snowman = new FrostGolemEntity(Main.FROST_GOLEM_ENTITY, player.field_70170_p, duration, this.getEnchantmentLevel(Enchantments.field_185305_q, rune));
                snowman.func_70080_a(entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), entityLiving.field_70177_z, entityLiving.field_70125_A);
                player.field_70170_p.func_217376_c((Entity)snowman);
            }
        }

        @Override
        public void onAttack(ItemStack sword, PlayerEntity player, Entity target, Set<ItemStack> runes) {
            if (player.func_70681_au().nextDouble() < 0.1 * (double)runes.size() + (double)this.getEnchantmentLevel(Enchantments.field_222192_G, runes) * 0.05) {
                int knockback = this.getEnchantmentLevel(Enchantments.field_180313_o, runes);
                int duration = 100 * (1 + this.getEnchantmentLevel(Enchantments.field_203196_F, runes));
                FrostballEntity snowball = new FrostballEntity(player.field_70170_p, (LivingEntity)player, knockback, duration);
                snowball.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                player.field_70170_p.func_217376_c((Entity)snowball);
            }
        }
    }

    private static class AxePowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_185305_q, (Object)Enchantments.field_180309_e, (Object)Enchantments.field_185308_t, (Object)Enchantments.field_185312_x, (Object)Enchantments.field_185309_u, (Object)Enchantments.field_185301_j, (Object[])new Enchantment[0]);
        private static final int BASE_DURATION = 200;

        private AxePowers() {
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return AxePowers.isAxe(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public float onBreakSpeed(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, float speed, Set<ItemStack> runes) {
            if (this.isCorrectTool(runeable, state) && (double)player.field_70170_p.func_226691_t_(pos).func_242445_k() < 0.5) {
                speed = (float)((double)speed + ((double)(runes.size() * 5) + (double)this.getEnchantmentLevel(Enchantments.field_185305_q, runes) * 0.8));
                if (player.field_70170_p.func_72896_J() && player.field_70170_p.func_226691_t_(pos).func_201851_b() == Biome.RainType.SNOW) {
                    speed += (float)(this.getEnchantmentLevel(Enchantments.field_180309_e, runes) * 2);
                }
            }
            return speed;
        }

        @Override
        public void onBlockBreakMajor(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, ItemStack rune) {
            if (field_77697_d.nextDouble() < 0.1 + (double)this.getEnchantmentLevel(Enchantments.field_185308_t, rune) * 0.05 && state.func_177230_c() == Blocks.field_196618_L) {
                int duration = 200 * (this.getEnchantmentLevel(Enchantments.field_185312_x, rune) > 0 ? 2 : 1);
                int level = field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185309_u, rune) * 0.02 ? 1 : 0;
                player.func_195064_c(new EffectInstance(Effects.field_76422_e, duration, level));
                if (field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185301_j, rune) * 0.1) {
                    player.func_195064_c(new EffectInstance(Effects.field_76424_c, duration, level));
                }
            }
        }
    }
}

