/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.item;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mod.vemerion.runesword.Main;
import mod.vemerion.runesword.capability.Runes;
import mod.vemerion.runesword.entity.MagicBallEntity;
import mod.vemerion.runesword.helpers.Helper;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.item.RunePowers;
import mod.vemerion.runesword.network.AxeMagicPowersMessage;
import mod.vemerion.runesword.network.Network;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class MagicRuneItem
extends RuneItem {
    private static final Map<Enchantment, Color> ENCHANTMENT_COLORS = new HashMap<Enchantment, Color>();
    private static final Color DEFAULT_COLOR = new Color(100, 0, 100, 255);

    public MagicRuneItem(Item.Properties properties) {
        super(Helper.color(100, 0, 100, 255), (List<RunePowers>)ImmutableList.of((Object)new SwordPowers(), (Object)new AxePowers()), properties);
    }

    public static void knockback(int knockback, int punch, Vector3d direction, Entity target) {
        Vector3d motion = direction.func_186678_a((double)knockback * 0.15);
        target.func_70024_g(motion.field_72450_a, (double)punch * 0.05, motion.field_72449_c);
        target.func_230245_c_(false);
    }

    public static void leaveTrail(World world, BlockPos pos, BlockState trail) {
        for (int i = 0; i < 5; ++i) {
            if (!world.func_175623_d(pos)) {
                return;
            }
            BlockState state = world.func_180495_p(pos.func_177977_b());
            if (state.func_200132_m() && state.func_215686_e((IBlockReader)world, pos.func_177977_b()) && trail.func_196955_c((IWorldReader)world, pos)) {
                world.func_175656_a(pos, trail);
                return;
            }
            pos = pos.func_177977_b();
        }
    }

    public static void bonusExp(World world, int looting, Vector3d pos) {
        int fragment;
        if (looting <= 0) {
            return;
        }
        for (int exp = world.field_73012_v.nextInt(looting + 1); exp > 0; exp -= fragment) {
            fragment = ExperienceOrbEntity.func_70527_a((int)exp);
            world.func_217376_c((Entity)new ExperienceOrbEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, fragment));
        }
    }

    private static void shootMagicBall(PlayerEntity player, World world, Map<Enchantment, Integer> enchantments, Vector3d position, float pitch, float yaw, float inaccuracy, float speed) {
        MagicBallEntity ball = new MagicBallEntity(position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), world, enchantments);
        ball.func_212361_a((Entity)player);
        ball.func_234612_a_((Entity)player, pitch, yaw, 0.0f, speed, inaccuracy);
        world.func_217376_c((Entity)ball);
    }

    private static Set<ItemStack> minorMagicRunes(Runes runes) {
        HashSet<ItemStack> minorRunes = new HashSet<ItemStack>();
        for (int i = 1; i < 4; ++i) {
            ItemStack rune = runes.getStackInSlot(i);
            if (!(rune.func_77973_b() instanceof MagicRuneItem)) continue;
            minorRunes.add(rune);
        }
        return minorRunes;
    }

    public static void applyMagicDamage(Entity target, DamageSource source, float damage, Map<Enchantment, Integer> enchants, Random rand, float multiplier) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            if (living.func_70668_bt() == CreatureAttribute.field_223224_c_) {
                damage = (float)((double)damage + (double)enchants.getOrDefault(Enchantments.field_180312_n, 0).intValue() * 0.4 * (double)multiplier);
            } else if (living.func_70668_bt() == CreatureAttribute.field_223223_b_) {
                damage = (float)((double)damage + (double)enchants.getOrDefault(Enchantments.field_185303_l, 0).intValue() * 0.4 * (double)multiplier);
            } else if (living.func_70668_bt() == CreatureAttribute.field_203100_e) {
                damage = (float)((double)damage + (double)enchants.getOrDefault(Enchantments.field_203194_D, 0).intValue() * 0.4 * (double)multiplier);
            }
        }
        damage = (float)((double)damage + (double)enchants.getOrDefault(Enchantments.field_185302_k, 0).intValue() * 0.3 * (double)multiplier);
        if (target.func_70090_H()) {
            damage += (float)(enchants.getOrDefault(Enchantments.field_185299_g, 0) * 2) * multiplier;
        }
        if (rand.nextDouble() < (double)enchants.getOrDefault(Enchantments.field_185308_t, 0).intValue() * 0.045) {
            damage *= 2.0f;
        }
        target.func_70097_a(source, damage);
    }

    public static ListNBT serializeEnchantments(Map<Enchantment, Integer> enchantments) {
        ListNBT list = new ListNBT();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("ench", entry.getKey().getRegistryName().toString());
            compound.func_74768_a("level", entry.getValue().intValue());
            list.add((Object)compound);
        }
        return list;
    }

    public static Map<Enchantment, Integer> deserializeEnchantments(ListNBT list) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            ResourceLocation ench;
            CompoundNBT compound = list.func_150305_b(i);
            if (!compound.func_74764_b("ench") || !compound.func_74764_b("level") || !ForgeRegistries.ENCHANTMENTS.containsKey(ench = new ResourceLocation(compound.func_74779_i("ench")))) continue;
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ench);
            int level = compound.func_74762_e("level");
            enchantments.put(enchantment, level);
        }
        return enchantments;
    }

    public static Color getRandEnchColor(Random rand, Enchantment[] enchantments) {
        Color color = DEFAULT_COLOR;
        if (enchantments.length > 0) {
            color = ENCHANTMENT_COLORS.getOrDefault(enchantments[rand.nextInt(enchantments.length)], DEFAULT_COLOR);
        }
        return color;
    }

    static {
        ENCHANTMENT_COLORS.put(Enchantments.field_185299_g, new Color(0, 0, 200));
        ENCHANTMENT_COLORS.put(Enchantments.field_180312_n, new Color(0, 0, 0));
        ENCHANTMENT_COLORS.put(Enchantments.field_185297_d, new Color(50, 20, 0));
        ENCHANTMENT_COLORS.put(Enchantments.field_203196_F, new Color(255, 255, 0));
        ENCHANTMENT_COLORS.put(Enchantments.field_185300_i, new Color(10, 10, 130));
        ENCHANTMENT_COLORS.put(Enchantments.field_185305_q, new Color(180, 180, 180));
        ENCHANTMENT_COLORS.put(Enchantments.field_180309_e, new Color(150, 220, 220));
        ENCHANTMENT_COLORS.put(Enchantments.field_77334_n, new Color(255, 130, 0));
        ENCHANTMENT_COLORS.put(Enchantments.field_77329_d, new Color(200, 130, 70));
        ENCHANTMENT_COLORS.put(Enchantments.field_185311_w, new Color(255, 130, 0));
        ENCHANTMENT_COLORS.put(Enchantments.field_185308_t, new Color(220, 220, 20));
        ENCHANTMENT_COLORS.put(Enchantments.field_185301_j, new Color(23, 220, 200));
        ENCHANTMENT_COLORS.put(Enchantments.field_203194_D, new Color(30, 30, 30));
        ENCHANTMENT_COLORS.put(Enchantments.field_185312_x, new Color(255, 255, 255));
        ENCHANTMENT_COLORS.put(Enchantments.field_180313_o, new Color(100, 100, 100));
        ENCHANTMENT_COLORS.put(Enchantments.field_185304_p, new Color(190, 180, 40));
        ENCHANTMENT_COLORS.put(Enchantments.field_203193_C, new Color(140, 80, 80));
        ENCHANTMENT_COLORS.put(Enchantments.field_151370_z, new Color(30, 90, 150));
        ENCHANTMENT_COLORS.put(Enchantments.field_151369_A, new Color(40, 70, 150));
        ENCHANTMENT_COLORS.put(Enchantments.field_185296_A, new Color(40, 130, 50));
        ENCHANTMENT_COLORS.put(Enchantments.field_222192_G, new Color(170, 190, 180));
        ENCHANTMENT_COLORS.put(Enchantments.field_222194_I, new Color(200, 200, 200));
        ENCHANTMENT_COLORS.put(Enchantments.field_185309_u, new Color(255, 20, 20));
        ENCHANTMENT_COLORS.put(Enchantments.field_180308_g, new Color(200, 200, 200));
        ENCHANTMENT_COLORS.put(Enchantments.field_180310_c, new Color(200, 200, 200));
        ENCHANTMENT_COLORS.put(Enchantments.field_185310_v, new Color(100, 100, 100));
        ENCHANTMENT_COLORS.put(Enchantments.field_222193_H, new Color(240, 70, 0));
        ENCHANTMENT_COLORS.put(Enchantments.field_185298_f, new Color(190, 255, 240));
        ENCHANTMENT_COLORS.put(Enchantments.field_203195_E, new Color(60, 100, 190));
        ENCHANTMENT_COLORS.put(Enchantments.field_185302_k, new Color(230, 230, 230));
        ENCHANTMENT_COLORS.put(Enchantments.field_185306_r, new Color(245, 245, 245));
        ENCHANTMENT_COLORS.put(Enchantments.field_185303_l, new Color(255, 230, 40));
        ENCHANTMENT_COLORS.put(Enchantments.field_234847_l_, new Color(50, 50, 40));
        ENCHANTMENT_COLORS.put(Enchantments.field_191530_r, new Color(200, 200, 200));
        ENCHANTMENT_COLORS.put(Enchantments.field_92091_k, new Color(0, 100, 20));
        ENCHANTMENT_COLORS.put(Enchantments.field_185307_s, new Color(200, 200, 200));
    }

    private static class SwordPowers
    extends RunePowers {
        private static final int COOLDOWN = 200;

        private SwordPowers() {
        }

        @Override
        public void onRightClickMajor(ItemStack sword, PlayerEntity player, ItemStack rune) {
            CooldownTracker cdTracker = player.func_184811_cZ();
            if (cdTracker.func_185141_a(rune.func_77973_b())) {
                return;
            }
            Runes.getRunes(sword).ifPresent(runes -> {
                World world = player.field_70170_p;
                Map<Enchantment, Integer> enchantments = this.getEnchantments(MagicRuneItem.minorMagicRunes(runes));
                int multishot = enchantments.getOrDefault(Enchantments.field_222192_G, 0);
                float inaccuracy = 1.0f - (float)enchantments.getOrDefault(Enchantments.field_185309_u, 0).intValue() / 15.0f;
                float speed = 0.5f + (float)enchantments.getOrDefault(Enchantments.field_234847_l_, 0).intValue() * 0.05f;
                int quickCharge = enchantments.getOrDefault(Enchantments.field_222193_H, 0);
                cdTracker.func_185145_a(rune.func_77973_b(), (int)(200.0 * (1.0 - (double)quickCharge * 0.05)));
                world.func_184133_a(null, player.func_233580_cy_(), Main.PROJECTILE_LAUNCH_SOUND, SoundCategory.PLAYERS, 1.0f, Helper.soundPitch(field_77697_d));
                if (multishot <= 0) {
                    Vector3d direction = Vector3d.func_189984_a((Vector2f)player.func_189653_aC());
                    Vector3d position = player.func_213303_ch().func_72441_c(direction.func_82615_a() * 1.0, 1.2, direction.func_82616_c() * 1.0);
                    MagicRuneItem.shootMagicBall(player, world, enchantments, position, player.field_70125_A, player.field_70177_z, inaccuracy, speed);
                } else {
                    int count = field_77697_d.nextInt(multishot) + 1;
                    for (int i = 0; i < count; ++i) {
                        Vector3d direction = Vector3d.func_189984_a((Vector2f)player.func_189653_aC()).func_178785_b((field_77697_d.nextFloat() - 0.5f) * 0.1f);
                        Vector3d position = player.func_213303_ch().func_72441_c(direction.func_82615_a() * 1.0, 1.2 + (field_77697_d.nextDouble() - 0.5) * 0.5, direction.func_82616_c() * 1.0);
                        MagicRuneItem.shootMagicBall(player, world, enchantments, position, player.field_70125_A + (float)field_77697_d.nextInt(30) - 15.0f, player.field_70177_z + (float)field_77697_d.nextInt(30) - 15.0f, inaccuracy, speed);
                    }
                }
                int luckOfTheSea = enchantments.getOrDefault(Enchantments.field_151370_z, 0);
                if (luckOfTheSea > 0) {
                    player.func_195064_c(new EffectInstance(Effects.field_76427_o, luckOfTheSea * 3 * 20));
                }
            });
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return SwordPowers.isSword(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return enchantment.getRegistryName().func_110624_b().equals("minecraft");
        }
    }

    private static class AxePowers
    extends RunePowers {
        private static final double START_RADIUS = 2.0;
        private static final float START_DAMAGE = 3.0f;
        private static final int START_COOLDOWN = 280;

        private AxePowers() {
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return AxePowers.isAxe(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return enchantment.getRegistryName().func_110624_b().equals("minecraft");
        }

        @Override
        public float onHurtMajor(ItemStack runeable, PlayerEntity player, DamageSource source, float amount, ItemStack rune) {
            Runes.getRunes(runeable).ifPresent(runes -> {
                Map<Enchantment, Integer> enchants = this.getEnchantments(MagicRuneItem.minorMagicRunes(runes));
                if (source.func_76346_g() instanceof LivingEntity && field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_180310_c, enchants) * 0.01) {
                    this.magicArea(enchants, player, player.field_70170_p);
                }
            });
            return super.onHurtMajor(runeable, player, source, amount, rune);
        }

        @Override
        public void onRightClickMajor(ItemStack runeable, PlayerEntity player, ItemStack rune) {
            CooldownTracker cdTracker = player.func_184811_cZ();
            if (cdTracker.func_185141_a(rune.func_77973_b())) {
                return;
            }
            Runes.getRunes(runeable).ifPresent(runes -> {
                World world = player.field_70170_p;
                Map<Enchantment, Integer> enchants = this.getEnchantments(MagicRuneItem.minorMagicRunes(runes));
                int cooldown = 280;
                int quickCharge = this.getEnchantmentLevel(Enchantments.field_222193_H, enchants);
                cooldown = (int)((double)cooldown * (1.0 - (double)quickCharge * 0.05));
                cdTracker.func_185145_a(rune.func_77973_b(), cooldown += this.getEnchantmentLevel(Enchantments.field_185312_x, enchants) * 20);
                this.magicArea(enchants, player, world);
            });
        }

        private void magicArea(Map<Enchantment, Integer> enchants, PlayerEntity player, World world) {
            world.func_184133_a(null, player.func_233580_cy_(), Main.PROJECTILE_IMPACT_SOUND, SoundCategory.PLAYERS, 1.0f, Helper.soundPitch(field_77697_d));
            double radius = 2.0;
            float damage = 3.0f;
            DamageSource source = Helper.magicDamage(player);
            if (player.func_70090_H()) {
                radius += (double)this.getEnchantmentLevel(Enchantments.field_185300_i, enchants) / 9.0;
            }
            radius += (double)this.getEnchantmentLevel(Enchantments.field_191530_r, enchants) / 9.0;
            if (player.func_184187_bx() instanceof HorseEntity) {
                radius += (double)this.getEnchantmentLevel(Enchantments.field_203193_C, enchants) / 6.0;
            }
            if (field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185307_s, enchants) * 0.1) {
                source.func_76348_h();
            }
            if ((double)player.func_184825_o(0.0f) > 0.99) {
                damage = (float)((double)damage + (double)this.getEnchantmentLevel(Enchantments.field_185309_u, enchants) * 0.5);
            }
            if (world.func_234923_W_() == World.field_234919_h_) {
                damage += (float)this.getEnchantmentLevel(Enchantments.field_185311_w, enchants);
            }
            if (player.func_70644_a(Effects.field_76424_c)) {
                damage = (float)((double)damage + (double)this.getEnchantmentLevel(Enchantments.field_234847_l_, enchants) * 0.4);
            }
            damage += (float)(this.getEnchantmentLevel(Enchantments.field_185312_x, enchants) * 2);
            AxisAlignedBB box = new AxisAlignedBB(player.func_213303_ch(), player.func_213303_ch()).func_72314_b(radius, 0.0, radius).func_72321_a(0.0, 2.0, 0.0);
            int channeling = this.getEnchantmentLevel(Enchantments.field_203196_F, enchants);
            int lure = this.getEnchantmentLevel(Enchantments.field_151369_A, enchants);
            int looting = this.getEnchantmentLevel(Enchantments.field_185304_p, enchants);
            int knockback = this.getEnchantmentLevel(Enchantments.field_180313_o, enchants);
            int punch = this.getEnchantmentLevel(Enchantments.field_185310_v, enchants);
            for (Entity e2 : world.func_175674_a((Entity)player, box, e -> e != player.func_184187_bx())) {
                damage += (float)channeling * player.func_70032_d(e2) * 0.3f;
                if (this.hasArmor(e2)) {
                    damage = (float)((double)damage + (double)this.getEnchantmentLevel(Enchantments.field_222194_I, enchants) * 0.4);
                }
                MagicRuneItem.applyMagicDamage(e2, source, damage, enchants, field_77697_d, 0.7f);
                Vector3d inwards = player.func_213303_ch().func_178788_d(e2.func_213303_ch()).func_72432_b();
                Vector3d pull = inwards.func_186678_a((double)lure / 9.0);
                e2.func_70024_g(pull.field_72450_a, pull.field_72448_b, pull.field_72449_c);
                if (field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_77334_n, enchants) * 0.08) {
                    e2.func_70015_d(3);
                }
                if (!e2.func_70089_S() && world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                    MagicRuneItem.bonusExp(world, looting, e2.func_213303_ch());
                }
                MagicRuneItem.knockback(knockback, punch, inwards.func_186678_a(-1.0), e2);
                if (!(e2 instanceof ProjectileEntity) || !(field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_180308_g, enchants) * 0.05)) continue;
                e2.func_70106_y();
            }
            if (field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185297_d, enchants) * 0.025) {
                world.func_217385_a((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 2.0f, Explosion.Mode.BREAK);
            }
            int efficiency = this.getEnchantmentLevel(Enchantments.field_185305_q, enchants);
            int thorns = this.getEnchantmentLevel(Enchantments.field_92091_k, enchants);
            int fireProt = this.getEnchantmentLevel(Enchantments.field_77329_d, enchants);
            int frostWalker = this.getEnchantmentLevel(Enchantments.field_185301_j, enchants);
            int silkTouch = this.getEnchantmentLevel(Enchantments.field_185306_r, enchants);
            int luckSea = this.getEnchantmentLevel(Enchantments.field_151370_z, enchants);
            BlockPos.func_239581_a_((AxisAlignedBB)box).forEach(p -> {
                BlockState state = world.func_180495_p(p);
                if (state.getHarvestTool() == ToolType.AXE && field_77697_d.nextDouble() < (double)efficiency * 0.03) {
                    world.func_175655_b(p, true);
                }
                if (field_77697_d.nextDouble() < (double)thorns * 0.02) {
                    MagicRuneItem.leaveTrail(world, p, Blocks.field_196674_t.func_176223_P());
                } else if (field_77697_d.nextDouble() < (double)fireProt * 0.01) {
                    MagicRuneItem.leaveTrail(world, p, Blocks.field_150480_ab.func_176223_P());
                } else if (field_77697_d.nextDouble() < (double)frostWalker * 0.03) {
                    MagicRuneItem.leaveTrail(world, p, Blocks.field_150433_aE.func_176223_P());
                } else if (field_77697_d.nextDouble() < (double)luckSea * 0.02 && player.func_70090_H()) {
                    MagicRuneItem.leaveTrail(world, p, Blocks.field_203198_aQ.func_176223_P());
                }
                if (field_77697_d.nextDouble() < (double)silkTouch * 0.1) {
                    BoneMealItem.applyBonemeal((ItemStack)Items.field_196106_bc.func_190903_i(), (World)world, (BlockPos)p, (PlayerEntity)player);
                }
            });
            if (field_77697_d.nextDouble() < (double)((float)this.getEnchantmentLevel(Enchantments.field_185296_A, enchants) / 3.0f)) {
                player.func_70691_i(1.0f);
            }
            int respiration = this.getEnchantmentLevel(Enchantments.field_185298_f, enchants);
            this.restoreAir(player, (float)respiration * 0.03f);
            if (field_77697_d.nextDouble() < (double)((float)this.getEnchantmentLevel(Enchantments.field_222192_G, enchants) / 3.0f)) {
                float pitch = field_77697_d.nextFloat() * 360.0f;
                float yaw = field_77697_d.nextFloat() * 360.0f;
                Vector3d position = player.func_213303_ch().func_72441_c(0.0, 1.5, 0.0);
                MagicRuneItem.shootMagicBall(player, world, enchants, position, pitch, yaw, 0.0f, 0.5f);
            }
            Network.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new AxeMagicPowersMessage(enchants, player.func_213303_ch(), radius));
        }

        private boolean hasArmor(Entity e) {
            for (ItemStack stack : e.func_184193_aE()) {
                if (stack.func_190926_b()) continue;
                return true;
            }
            return false;
        }
    }
}

