/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.item;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mod.vemerion.runesword.item.IRunePowers;
import mod.vemerion.runesword.item.RunePowers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="runesword")
public abstract class RuneItem
extends Item
implements IRunePowers {
    public static final Item FIRE_RUNE_ITEM = null;
    public static final Item WATER_RUNE_ITEM = null;
    public static final Item EARTH_RUNE_ITEM = null;
    public static final Item AIR_RUNE_ITEM = null;
    public static final Item BLOOD_RUNE_ITEM = null;
    public static final Item FROST_RUNE_ITEM = null;
    public static final Item MAGIC_RUNE_ITEM = null;
    private static final List<RuneItem> RUNES = new ArrayList<RuneItem>();
    private final int color;
    private final List<RunePowers> powers;

    public RuneItem(int color, List<RunePowers> powers, Item.Properties properties) {
        super(properties);
        this.color = color;
        this.powers = powers;
        RUNES.add(this);
    }

    @Override
    public void onAttack(ItemStack runeable, PlayerEntity player, Entity target, Set<ItemStack> runes) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            p.onAttack(runeable, player, target, runes);
        }
    }

    @Override
    public void onAttackMajor(ItemStack runeable, PlayerEntity player, Entity target, ItemStack rune) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            p.onAttackMajor(runeable, player, target, rune);
        }
    }

    @Override
    public void onKill(ItemStack runeable, PlayerEntity player, LivingEntity entityLiving, DamageSource source, Set<ItemStack> runes) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            p.onKill(runeable, player, entityLiving, source, runes);
        }
    }

    @Override
    public void onKillMajor(ItemStack runeable, PlayerEntity player, LivingEntity entityLiving, DamageSource source, ItemStack rune) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            p.onKillMajor(runeable, player, entityLiving, source, rune);
        }
    }

    @Override
    public float onHurt(ItemStack runeable, PlayerEntity player, DamageSource source, float amount, Set<ItemStack> runes) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            amount = p.onHurt(runeable, player, source, amount, runes);
        }
        return amount;
    }

    @Override
    public float onHurtMajor(ItemStack runeable, PlayerEntity player, DamageSource source, float amount, ItemStack rune) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            amount = p.onHurtMajor(runeable, player, source, amount, rune);
        }
        return amount;
    }

    @Override
    public void onRightClick(ItemStack runeable, PlayerEntity player, Set<ItemStack> runes) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            p.onRightClick(runeable, player, runes);
        }
    }

    @Override
    public void onRightClickMajor(ItemStack runeable, PlayerEntity player, ItemStack rune) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            p.onRightClickMajor(runeable, player, rune);
        }
    }

    @Override
    public float onBreakSpeed(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, float speed, Set<ItemStack> runes) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            speed = p.onBreakSpeed(runeable, player, state, pos, speed, runes);
        }
        return speed;
    }

    @Override
    public float onBreakSpeedMajor(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, float speed, ItemStack rune) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            speed = p.onBreakSpeedMajor(runeable, player, state, pos, speed, rune);
        }
        return speed;
    }

    @Override
    public boolean onHarvestCheckMajor(ItemStack runeable, PlayerEntity player, BlockState state, boolean canHarvest, ItemStack rune) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            canHarvest = p.onHarvestCheckMajor(runeable, player, state, canHarvest, rune);
        }
        return canHarvest;
    }

    @Override
    public void onBlockBreak(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, Set<ItemStack> runes) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            p.onBlockBreak(runeable, player, state, pos, runes);
        }
    }

    @Override
    public void onBlockBreakMajor(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, ItemStack rune) {
        for (RunePowers p : this.powers) {
            if (!p.canActivatePowers(runeable)) continue;
            p.onBlockBreakMajor(runeable, player, state, pos, rune);
        }
    }

    public int getColor() {
        return this.color;
    }

    public static Iterable<RuneItem> getRunes() {
        return Iterables.unmodifiableIterable(RUNES);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 10;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        for (RunePowers p : this.powers) {
            if (!p.isBeneficialEnchantment(enchantment)) continue;
            return true;
        }
        return false;
    }
}

