/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import mod.vemerion.runesword.item.RuneItem;
import mod.vemerion.runesword.item.RunePowers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;

public class WaterRuneItem
extends RuneItem {
    public WaterRuneItem(Item.Properties properties) {
        super(new Color(0, 50, 255).getRGB(), (List<RunePowers>)ImmutableList.of((Object)new SwordPowers(), (Object)new AxePowers()), properties);
    }

    private static class SwordPowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_185299_g, (Object)Enchantments.field_185302_k, (Object)Enchantments.field_180310_c, (Object)Enchantments.field_185298_f, (Object)Enchantments.field_151370_z);

        private SwordPowers() {
        }

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return SwordPowers.isSword(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public void onAttackMajor(ItemStack sword, PlayerEntity player, Entity target, ItemStack rune) {
            if (player.func_70090_H() || this.getEnchantmentLevel(Enchantments.field_185299_g, rune) > 0 && player.func_70026_G()) {
                float damage = 3.0f + (float)this.getEnchantmentLevel(Enchantments.field_185302_k, rune) * 0.4f;
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), damage);
                target.field_70172_ad = 0;
            }
        }

        @Override
        public float onHurtMajor(ItemStack sword, PlayerEntity player, DamageSource source, float amount, ItemStack rune) {
            if (player.func_70090_H() || this.getEnchantmentLevel(Enchantments.field_185299_g, rune) > 0 && player.func_70026_G()) {
                amount *= 1.0f - 0.05f * (float)this.getEnchantmentLevel(Enchantments.field_180310_c, rune);
            }
            return amount;
        }

        @Override
        public void onKill(ItemStack sword, PlayerEntity player, LivingEntity entityLiving, DamageSource source, Set<ItemStack> runes) {
            int respiration = this.getEnchantmentLevel(Enchantments.field_185298_f, runes);
            int air = player.func_70086_ai() + (int)(((double)runes.size() + (double)respiration * 0.34) * (double)((float)player.func_205010_bg() / 10.0f));
            player.func_70050_g(Math.min(player.func_205010_bg(), air));
        }

        @Override
        public float onHurt(ItemStack sword, PlayerEntity player, DamageSource source, float amount, Set<ItemStack> runes) {
            if (source == DamageSource.field_76369_e && player.func_70681_au().nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_151370_z, runes) * 0.03) {
                player.func_70050_g(Math.min(player.func_205010_bg(), player.func_70086_ai() + (int)((double)player.func_205010_bg() * 0.1)));
            }
            return super.onHurt(sword, player, source, amount, runes);
        }
    }

    public static class AxePowers
    extends RunePowers {
        private static final Set<Enchantment> ENCHANTS = ImmutableSet.of((Object)Enchantments.field_151370_z, (Object)Enchantments.field_151369_A, (Object)Enchantments.field_185311_w, (Object)Enchantments.field_185305_q, (Object)Enchantments.field_185298_f);

        @Override
        public boolean canActivatePowers(ItemStack stack) {
            return AxePowers.isAxe(stack);
        }

        @Override
        public boolean isBeneficialEnchantment(Enchantment enchantment) {
            return ENCHANTS.contains(enchantment);
        }

        @Override
        public void onKill(ItemStack runeable, PlayerEntity player, LivingEntity target, DamageSource source, Set<ItemStack> runes) {
            if (target.func_70668_bt() == CreatureAttribute.field_203100_e) {
                double chance = (double)runes.size() * 0.1;
                chance += (double)this.getEnchantmentLevel(Enchantments.field_151370_z, runes) * 0.03;
                if (!target.func_70090_H()) {
                    chance += (double)this.getEnchantmentLevel(Enchantments.field_151369_A, runes) * 0.1;
                }
                if (field_77697_d.nextDouble() < chance) {
                    Block log = Blocks.field_196617_K;
                    if (field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185311_w, runes) * 0.1) {
                        log = field_77697_d.nextBoolean() ? Blocks.field_235379_ms_ : Blocks.field_235370_mj_;
                    }
                    this.spawnItem(player.field_70170_p, target.func_233580_cy_(), log.func_199767_j().func_190903_i());
                }
            }
        }

        @Override
        public float onBreakSpeedMajor(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, float speed, ItemStack rune) {
            if (this.isCorrectTool(runeable, state) && player.func_203008_ap()) {
                speed += (float)(20 + this.getEnchantmentLevel(Enchantments.field_185305_q, rune) * 2);
            }
            return speed;
        }

        @Override
        public void onBlockBreakMajor(ItemStack runeable, PlayerEntity player, BlockState state, BlockPos pos, ItemStack rune) {
            if (this.isCorrectTool(runeable, state) && player.func_203008_ap() && field_77697_d.nextDouble() < (double)this.getEnchantmentLevel(Enchantments.field_185298_f, rune) * 0.1) {
                player.func_70050_g(Math.min(player.func_205010_bg(), player.func_70086_ai() + (int)((double)player.func_205010_bg() * 0.1)));
            }
        }
    }
}

