/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.network;

import java.awt.Color;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import mod.vemerion.runesword.item.MagicRuneItem;
import mod.vemerion.runesword.particle.MagicBallParticleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class AxeMagicPowersMessage {
    private Map<Enchantment, Integer> enchantments;
    private Vector3d pos;
    private double radius;

    public AxeMagicPowersMessage(Map<Enchantment, Integer> enchantments, Vector3d pos, double radius) {
        this.enchantments = enchantments;
        this.pos = pos;
        this.radius = radius;
    }

    public void encode(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("enchantments", (INBT)MagicRuneItem.serializeEnchantments(this.enchantments));
        buffer.func_150786_a(compound);
        buffer.writeDouble(this.pos.field_72450_a);
        buffer.writeDouble(this.pos.field_72448_b);
        buffer.writeDouble(this.pos.field_72449_c);
        buffer.writeDouble(this.radius);
    }

    public static AxeMagicPowersMessage decode(PacketBuffer buffer) {
        Map<Enchantment, Integer> enchantments = MagicRuneItem.deserializeEnchantments(buffer.func_150793_b().func_150295_c("enchantments", 10));
        Vector3d pos = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        double radius = buffer.readDouble();
        return new AxeMagicPowersMessage(enchantments, pos, radius);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> Particles.create(this.enchantments, this.pos, this.radius)));
    }

    private static class Particles {
        private Particles() {
        }

        private static DistExecutor.SafeRunnable create(final Map<Enchantment, Integer> enchantments, final Vector3d pos, final double radius) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    ClientWorld world = mc.field_71441_e;
                    ClientPlayerEntity player = mc.field_71439_g;
                    if (world != null && player != null) {
                        this.createParticles(enchantments, pos, radius, (World)world);
                        double up = (double)enchantments.getOrDefault(Enchantments.field_180309_e, 0).intValue() / 12.0;
                        double forward = (double)enchantments.getOrDefault(Enchantments.field_203195_E, 0).intValue() / 9.0;
                        Vector3d direction = Vector3d.func_189986_a((float)0.0f, (float)player.field_70177_z);
                        player.func_70024_g(direction.field_72450_a * forward, up, direction.field_72449_c * forward);
                    }
                }

                private void createParticles(Map<Enchantment, Integer> enchantments2, Vector3d pos2, double radius2, World world) {
                    Random rand = world.field_73012_v;
                    Enchantment[] enchantmentArr = enchantments2.keySet().toArray(new Enchantment[0]);
                    for (int i = 0; i < 200; ++i) {
                        Color color = MagicRuneItem.getRandEnchColor(rand, enchantmentArr);
                        double direction = Math.toRadians(rand.nextDouble() * 360.0);
                        double distance = rand.nextDouble() * radius2;
                        Vector3d particlePos = pos2.func_72441_c(Math.cos(direction) * distance, rand.nextDouble() * 2.0, Math.sin(direction) * distance);
                        world.func_195594_a((IParticleData)new MagicBallParticleData((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
                    }
                }
            };
        }
    }
}

