/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.network;

import java.util.function.Supplier;
import mod.vemerion.runesword.capability.EntityRuneData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncBleedingMessage {
    private boolean isBleeding;
    private int id;

    public SyncBleedingMessage(boolean isBleeding, int id) {
        this.isBleeding = isBleeding;
        this.id = id;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.isBleeding);
        buffer.writeInt(this.id);
    }

    public static SyncBleedingMessage decode(PacketBuffer buffer) {
        return new SyncBleedingMessage(buffer.readBoolean(), buffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> Handle.bleeding(this.isBleeding, this.id)));
    }

    private static class Handle {
        private Handle() {
        }

        private static DistExecutor.SafeRunnable bleeding(final boolean isBleeding, final int id) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    Entity e;
                    Minecraft mc = Minecraft.func_71410_x();
                    ClientWorld world = mc.field_71441_e;
                    if (world != null && (e = world.func_73045_a(id)) != null) {
                        EntityRuneData.get(e).ifPresent(d -> d.setBleeding(isBleeding));
                    }
                }
            };
        }
    }
}

