/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.runesword.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import mod.vemerion.runesword.Main;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class MagicBallParticleData
implements IParticleData {
    public static final Codec<MagicBallParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(data -> Float.valueOf(data.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(data -> Float.valueOf(data.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(data -> Float.valueOf(data.getBlue()))).apply((Applicative)instance, MagicBallParticleData::new));
    private float red;
    private float green;
    private float blue;

    public MagicBallParticleData(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ParticleType<?> func_197554_b() {
        return Main.MAGIC_BALL_PARTICLE;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.getRed());
        buffer.writeFloat(this.getGreen());
        buffer.writeFloat(this.getBlue());
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", this.func_197554_b().getRegistryName().toString(), Float.valueOf(this.getRed()), Float.valueOf(this.getGreen()), Float.valueOf(this.getBlue()));
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public static class Deserializer
    implements IParticleData.IDeserializer<MagicBallParticleData> {
        public MagicBallParticleData deserialize(ParticleType<MagicBallParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            float[] colors = new float[3];
            for (int i = 0; i < 3; ++i) {
                reader.expect(' ');
                colors[i] = reader.readFloat();
            }
            return new MagicBallParticleData(colors[0], colors[1], colors[2]);
        }

        public MagicBallParticleData read(ParticleType<MagicBallParticleData> particleTypeIn, PacketBuffer buffer) {
            return new MagicBallParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    }
}

