/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.monster;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.savage_and_ravage.common.block.RunedGloomyTilesBlock;
import com.teamabnormals.savage_and_ravage.common.entity.TracksHits;
import com.teamabnormals.savage_and_ravage.common.entity.projectile.ConfusionBolt;
import com.teamabnormals.savage_and_ravage.common.entity.projectile.RunePrison;
import com.teamabnormals.savage_and_ravage.core.other.SRDataProcessors;
import com.teamabnormals.savage_and_ravage.core.other.SRDataSerializers;
import com.teamabnormals.savage_and_ravage.core.other.SREvents;
import com.teamabnormals.savage_and_ravage.core.registry.SRBlocks;
import com.teamabnormals.savage_and_ravage.core.registry.SRItems;
import com.teamabnormals.savage_and_ravage.core.registry.SRParticleTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRSounds;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Trickster
extends SpellcasterIllager
implements TracksHits {
    private static final EntityDataAccessor<Integer> PRISON_CHARGING_TIME = SynchedEntityData.m_135353_(Trickster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<Vec3>> PRISON_POS = SynchedEntityData.m_135353_(Trickster.class, SRDataSerializers.OPTIONAL_VECTOR3D);
    private static final int chargeTime = 4;
    private static final int prisonTime = 60;
    private final Set<Entity> trackedSpellEntities = new HashSet<Entity>();

    public Trickster(EntityType<? extends SpellcasterIllager> type, Level p_i48551_2_) {
        super(type, p_i48551_2_);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SpellcasterIllager.SpellcasterCastingSpellGoal((SpellcasterIllager)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new CreatePrisonGoal());
        this.f_21345_.m_25352_(6, (Goal)new ThrowBoltGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 8.0f, 0.6, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, 10, true, false, target -> (Integer)TrackedDataManager.INSTANCE.getValue((Entity)this, SRDataProcessors.TOTEM_SHIELD_TIME) <= 0).m_26146_(300));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 10, true, false, target -> (Integer)TrackedDataManager.INSTANCE.getValue((Entity)this, SRDataProcessors.TOTEM_SHIELD_TIME) <= 0).m_26146_(300));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, target -> (Integer)TrackedDataManager.INSTANCE.getValue((Entity)this, SRDataProcessors.TOTEM_SHIELD_TIME) <= 0).m_26146_(300));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PRISON_CHARGING_TIME, (Object)-1);
        this.f_19804_.m_135372_(PRISON_POS, Optional.empty());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("PrisonChargingTime", 3)) {
            this.f_19804_.m_135381_(PRISON_CHARGING_TIME, (Object)compound.m_128451_("PrisonChargingTime"));
        }
        if (compound.m_128425_("PrisonX", 6) && compound.m_128425_("PrisonY", 6) && compound.m_128425_("PrisonZ", 6)) {
            this.f_19804_.m_135381_(PRISON_POS, Optional.of(new Vec3((double)compound.m_128451_("PrisonX"), (double)compound.m_128451_("PrisonY"), (double)compound.m_128451_("PrisonX"))));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("PrisonChargingTime", ((Integer)this.f_19804_.m_135370_(PRISON_CHARGING_TIME)).intValue());
        if ((Integer)this.f_19804_.m_135370_(PRISON_CHARGING_TIME) > 0) {
            ((Optional)this.f_19804_.m_135370_(PRISON_POS)).ifPresent(pos -> {
                compound.m_128347_("PrisonX", pos.f_82479_);
                compound.m_128347_("PrisonY", pos.f_82480_);
                compound.m_128347_("PrisonZ", pos.f_82481_);
            });
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.775f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19796_.m_188503_(14) == 0 && this.m_33736_()) {
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            SimpleParticleType particle = this.m_33737_() == SpellcasterIllager.IllagerSpell.FANGS ? (ParticleOptions)SRParticleTypes.RUNE.get() : ParticleTypes.f_123811_;
            this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20185_() + (double)f1 * 0.8, this.m_20186_() + 1.5, this.m_20189_() + (double)f2 * 0.6, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20185_() - (double)f1 * 0.8, this.m_20186_() + 1.5, this.m_20189_() - (double)f2 * 0.6, 0.0, 0.0, 0.0);
        }
        ((Optional)this.f_19804_.m_135370_(PRISON_POS)).ifPresent(pos -> {
            int time = (Integer)this.f_19804_.m_135370_(PRISON_CHARGING_TIME);
            if (time > 0) {
                int loops = 10 * (4 - time) + 1;
                for (int i = 0; i < loops; ++i) {
                    double progress = (double)time / 4.0 - 0.25 * ((double)i / (double)loops);
                    double coefficient = 0.65625 - 0.34375 * progress;
                    double adjustment = 0.34375 - 0.34375 * progress;
                    double x = pos.f_82479_ + (double)(this.f_19796_.m_188503_(2) == 0 ? 1 : -1) * 0.65625 * this.f_19796_.m_188500_();
                    double z = pos.f_82481_ + (double)(this.f_19796_.m_188503_(2) == 0 ? 1 : -1) * (Math.abs(pos.f_82479_ - x) < 0.34375 ? coefficient * this.f_19796_.m_188500_() + adjustment : 0.65625 * this.f_19796_.m_188500_());
                    this.f_19853_.m_7106_((ParticleOptions)SRParticleTypes.RUNE.get(), x, pos.f_82480_ + 0.8125, z, 0.0, 0.0, 0.0);
                }
                this.f_19804_.m_135381_(PRISON_CHARGING_TIME, (Object)(time - 1));
            } else if (time == 0) {
                RunePrison runePrison = new RunePrison(this.f_19853_, null, 60, false, this);
                runePrison.m_7678_(pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 0.0f, 0.0f);
                this.f_19853_.m_7967_((Entity)runePrison);
                this.trackedSpellEntities.add(runePrison);
                this.f_19804_.m_135381_(PRISON_POS, Optional.empty());
                this.f_19804_.m_135381_(PRISON_CHARGING_TIME, (Object)-1);
            }
        });
        this.trackedSpellEntities.removeIf(Objects::isNull);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        IDataManager data = (IDataManager)this;
        if (source.m_7640_() instanceof Projectile && this.m_21223_() - amount <= 0.0f && (Integer)data.getValue(SRDataProcessors.TOTEM_SHIELD_COOLDOWN) <= 0) {
            this.m_21153_(2.0f);
            data.setValue(SRDataProcessors.TOTEM_SHIELD_COOLDOWN, (Object)1800);
            if (!this.f_19853_.m_5776_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)35);
                for (int i = 0; i < 64; ++i) {
                    if (!this.teleport()) continue;
                    return true;
                }
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected boolean teleport() {
        if (this.m_6084_()) {
            double randomX = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double randomZ = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            BlockState state = this.f_19853_.m_8055_((BlockPos)new BlockPos.MutableBlockPos(randomX, this.m_20186_() - 1.0, randomZ));
            if (state.m_60767_().m_76334_() && !state.m_60819_().m_205070_(FluidTags.f_13132_)) {
                AABB oldBox = this.m_20191_().m_82400_(0.5);
                BlockPos oldPos = this.m_20183_();
                boolean successful = this.m_20984_(randomX, this.m_20186_(), randomZ, true);
                if (successful) {
                    this.f_19853_.m_5594_(null, oldPos, (SoundEvent)SRSounds.GENERIC_PUFF_OF_SMOKE.get(), this.m_5720_(), 10.0f, 1.0f);
                    this.f_19853_.m_5594_(null, this.m_20183_(), (SoundEvent)SRSounds.GENERIC_PUFF_OF_SMOKE.get(), this.m_5720_(), 10.0f, 1.0f);
                    this.f_19853_.m_5594_(null, oldPos, (SoundEvent)SRSounds.ENTITY_TRICKSTER_LAUGH.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    ConfusionBolt.spawnGaussianParticles(this.f_19853_, this.f_19796_, oldBox, SREvents.POOF_KEY, 50);
                    ConfusionBolt.spawnGaussianParticles(this.f_19853_, this.f_19796_, this.m_20191_().m_82400_(0.5), SREvents.POOF_KEY, 50);
                    if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                        BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
                        for (int x = oldPos.m_123341_() - 2; x <= oldPos.m_123341_() + 2; ++x) {
                            for (int y = oldPos.m_123342_() - 2; y <= oldPos.m_123342_() + 2; ++y) {
                                for (int z = oldPos.m_123343_() - 2; z <= oldPos.m_123343_() + 2; ++z) {
                                    searchPos.m_122178_(x, y, z);
                                    if (this.f_19853_.m_8055_((BlockPos)searchPos).m_60734_() != SRBlocks.GLOOMY_TILES.get()) continue;
                                    this.f_19853_.m_7731_((BlockPos)searchPos, ((Block)SRBlocks.RUNED_GLOOMY_TILES.get()).m_49966_(), 2);
                                    searchPos.m_122173_(Direction.UP);
                                    if (this.f_19853_.f_46443_ || this.f_19853_.m_8055_((BlockPos)searchPos).m_60804_((BlockGetter)this.f_19853_, (BlockPos)searchPos)) continue;
                                    for (int i = 0; i < 3; ++i) {
                                        NetworkUtil.spawnParticle((String)SRParticleTypes.RUNE.getId().toString(), (ResourceKey)this.f_19853_.m_46472_(), (double)((double)x + this.f_19796_.m_188500_()), (double)((double)y + 1.25), (double)((double)z + this.f_19796_.m_188500_()), (double)0.0, (double)0.0, (double)0.0);
                                    }
                                }
                            }
                        }
                    }
                }
                return successful;
            }
        }
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_DEATH.get();
    }

    public void m_8032_() {
        if ((Integer)this.f_19804_.m_135370_(PRISON_CHARGING_TIME) < 0 && this.trackedSpellEntities.isEmpty()) {
            super.m_8032_();
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
        this.m_5496_((SoundEvent)SRSounds.ENTITY_TRICKSTER_STEP.get(), 0.5f, 1.0f);
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_CAST_SPELL.get();
    }

    public void m_7895_(int wave, boolean p_213660_2_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_CELEBRATE.get();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)SRItems.TRICKSTER_SPAWN_EGG.get());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    @Override
    @Nullable
    public void onTrackedHit(Entity hitter, Entity hit) {
        if (RunedGloomyTilesBlock.shouldTrigger(hit, false) && this.trackedSpellEntities.contains(hitter)) {
            this.f_19853_.m_5594_(null, this.m_20183_(), (SoundEvent)SRSounds.ENTITY_TRICKSTER_LAUGH.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            this.trackedSpellEntities.remove(hitter);
        }
    }

    class CreatePrisonGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        CreatePrisonGoal() {
            super((SpellcasterIllager)Trickster.this);
        }

        protected void m_8130_() {
            LivingEntity target = Trickster.this.m_5448_();
            if (target != null) {
                Trickster.this.f_19804_.m_135381_(PRISON_POS, Optional.of(target.m_20182_()));
                Trickster.this.f_19804_.m_135381_(PRISON_CHARGING_TIME, (Object)4);
            }
        }

        protected int m_8089_() {
            return 40;
        }

        protected int m_8067_() {
            return 100;
        }

        @Nullable
        protected SoundEvent m_7030_() {
            return (SoundEvent)SRSounds.GENERIC_PREPARE_ATTACK.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    class ThrowBoltGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        ThrowBoltGoal() {
            super((SpellcasterIllager)Trickster.this);
        }

        protected void m_8130_() {
            Level world = Trickster.this.f_19853_;
            LivingEntity target = Trickster.this.m_5448_();
            if (target != null) {
                ConfusionBolt bolt = new ConfusionBolt(world, (LivingEntity)Trickster.this, 240);
                Vec3 pos = Trickster.this.m_20182_();
                Vec3 targetPos = target.m_20182_();
                bolt.m_6034_(bolt.m_20185_(), bolt.m_20186_() - 0.5, bolt.m_20189_());
                bolt.m_20256_(new Vec3(targetPos.f_82479_ - pos.f_82479_, targetPos.f_82480_ - pos.f_82480_, targetPos.f_82481_ - pos.f_82481_).m_82541_().m_82490_(0.25));
                world.m_7967_((Entity)bolt);
                Trickster.this.trackedSpellEntities.add((Entity)bolt);
            }
        }

        protected int m_8089_() {
            return 80;
        }

        protected int m_8067_() {
            return 340;
        }

        @Nullable
        protected SoundEvent m_7030_() {
            return (SoundEvent)SRSounds.GENERIC_PREPARE_ATTACK.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }
}

