/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.export;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiPrivate;
import com.lothrazar.storagenetwork.block.cable.export.ContainerCableExportFilter;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.gui.ButtonRequest;
import com.lothrazar.storagenetwork.gui.ItemSlotNetwork;
import com.lothrazar.storagenetwork.network.CableIOMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiCableExportFilter
extends ContainerScreen<ContainerCableExportFilter>
implements IGuiPrivate {
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/cable_filter.png");
    ContainerCableExportFilter containerCableLink;
    private ButtonRequest btnRedstone;
    private ButtonRequest btnMinus;
    private ButtonRequest btnPlus;
    private ButtonRequest btnImport;
    private boolean isAllowlist;
    private List<ItemSlotNetwork> itemSlotsGhost;
    public static final int SLOT_SIZE = 18;

    public GuiCableExportFilter(ContainerCableExportFilter containerCableFilter, PlayerInventory inv, ITextComponent name) {
        super((Container)containerCableFilter, inv, name);
        this.containerCableLink = containerCableFilter;
    }

    @Override
    public void renderStackTooltip(MatrixStack ms, ItemStack stack, int mousex, int mousey) {
        super.func_230457_a_(ms, stack, mousex, mousey);
    }

    @Override
    public void drawGradient(MatrixStack ms, int x, int y, int x2, int y2, int u, int v) {
        super.func_238468_a_(ms, x, y, x2, y2, u, v);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.isAllowlist = this.containerCableLink.cap.getFilter().isAllowList;
        this.btnRedstone = (ButtonRequest)this.func_230480_a_((Widget)new ButtonRequest(this.field_147003_i + 4, this.field_147009_r + 4, "", p -> {
            this.syncData(0);
            PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.REDSTONE.ordinal()));
        }));
        this.btnMinus = (ButtonRequest)this.func_230480_a_((Widget)new ButtonRequest(this.field_147003_i + 28, this.field_147009_r + 6, "", p -> this.syncData(-1)));
        this.btnMinus.setTextureId(ButtonRequest.TextureEnum.MINUS);
        this.btnPlus = (ButtonRequest)this.func_230480_a_((Widget)new ButtonRequest(this.field_147003_i + 60, this.field_147009_r + 6, "", p -> this.syncData(1)));
        this.btnPlus.setTextureId(ButtonRequest.TextureEnum.PLUS);
        this.btnImport = (ButtonRequest)this.func_230480_a_((Widget)new ButtonRequest(this.field_147003_i + 80, this.field_147009_r + 6, "", p -> this.importFilterSlots()));
        this.btnImport.setTextureId(ButtonRequest.TextureEnum.IMPORT);
    }

    private void importFilterSlots() {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.IMPORT_FILTER.ordinal()));
    }

    private void sendStackSlot(int value, ItemStack stack) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SAVE_FITLER.ordinal(), value, stack));
    }

    private void syncData(int priority) {
        this.containerCableLink.cap.getFilter().isAllowList = this.isAllowlist;
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SYNC_DATA.ordinal(), priority, this.isAllowlist));
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ms, mouseX, mouseY);
        this.btnRedstone.setTextureId(this.containerCableLink.cap.needsRedstone() ? ButtonRequest.TextureEnum.REDSTONETRUE : ButtonRequest.TextureEnum.REDSTONEFALSE);
    }

    public void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        int priority = this.containerCableLink.cap.getPriority();
        this.field_230712_o_.func_238421_b_(ms, String.valueOf(priority), (float)(50 - this.field_230712_o_.func_78256_a(String.valueOf(priority)) / 2), 12.0f, 0x404040);
        this.drawTooltips(ms, mouseX, mouseY);
    }

    private void drawTooltips(MatrixStack ms, int mouseX, int mouseY) {
        if (this.btnImport != null && this.btnImport.func_231047_b_(mouseX, mouseY)) {
            this.renderWrappedToolTip(ms, Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("gui.storagenetwork.import")}), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_230712_o_);
        }
        if (this.btnMinus != null && this.btnMinus.func_231047_b_(mouseX, mouseY)) {
            this.renderWrappedToolTip(ms, Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("gui.storagenetwork.priority.down")}), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_230712_o_);
        }
        if (this.btnPlus != null && this.btnPlus.func_231047_b_(mouseX, mouseY)) {
            this.renderWrappedToolTip(ms, Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("gui.storagenetwork.priority.up")}), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_230712_o_);
        }
        if (this.btnRedstone != null && this.btnRedstone.func_231047_b_(mouseX, mouseY)) {
            this.renderWrappedToolTip(ms, Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("gui.storagenetwork.redstone." + this.containerCableLink.cap.needsRedstone())}), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_230712_o_);
        }
    }

    protected void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(this.texture);
        int xCenter = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yCenter = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(ms, xCenter, yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 45;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                ItemStack stack = this.containerCableLink.cap.getFilter().getStackInSlot(index);
                int x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.field_147003_i + x, this.field_147009_r + y, stack.func_190916_E(), this.field_147003_i, this.field_147009_r, true));
                ++index;
            }
            y += 18;
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(ms, this.field_230712_o_, mouseX, mouseY);
        }
    }

    public void setFilterItems(List<ItemStack> stacks) {
        FilterItemStackHandler filter = this.containerCableLink.cap.getFilter();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            filter.setStackInSlot(i, s);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        ItemStack mouse = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
            ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
            if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY)) continue;
            if (!slot.getStack().func_190926_b()) {
                if (mouseButton == 1) {
                    int direction = GuiCableExportFilter.func_231173_s_() ? -1 : 1;
                    int newCount = Math.min(64, slot.getStack().func_190916_E() + direction);
                    if (newCount < 1) {
                        newCount = 1;
                    }
                    slot.getStack().func_190920_e(newCount);
                } else {
                    slot.setStack(ItemStack.field_190927_a);
                }
                this.sendStackSlot(i, slot.getStack());
                return true;
            }
            slot.setStack(mouse.func_77946_l());
            this.sendStackSlot(i, mouse.func_77946_l());
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.func_195359_a(x, y, width, height, mouseX, mouseY);
    }
}

