/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.input;

import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.block.TileCableWithFacing;
import com.lothrazar.storagenetwork.block.cable.BlockCable;
import com.lothrazar.storagenetwork.block.cable.EnumConnectType;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableAutoIO;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileCableIO
extends TileCableWithFacing
implements ITickableTileEntity {
    protected CapabilityConnectableAutoIO ioStorage = new CapabilityConnectableAutoIO(this, EnumStorageDirection.IN);

    public TileCableIO() {
        super(SsnRegistry.IMPORTKABELTILE);
    }

    @Override
    public void setDirection(Direction direction) {
        super.setDirection(direction);
        this.ioStorage.setInventoryFace(direction);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT compound) {
        super.func_230337_a_(bs, compound);
        this.ioStorage.deserializeNBT(compound.func_74775_l("ioStorage"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT result = super.func_189515_b(compound);
        result.func_218657_a("ioStorage", (INBT)this.ioStorage.serializeNBT());
        return result;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_AUTO_IO) {
            LazyOptional cap = LazyOptional.of(() -> this.ioStorage);
            return cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.getDirection() == null) {
            this.findNewDirection();
            if (this.getDirection() != null) {
                BlockState newState = BlockCable.cleanBlockState(this.func_195044_w());
                newState = (BlockState)newState.func_206870_a((Property)BlockCable.FACING_TO_PROPERTY_MAP.get(this.getDirection()), (Comparable)((Object)EnumConnectType.CABLE));
                this.field_145850_b.func_175656_a(this.field_174879_c, newState);
            }
        }
    }
}

