/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemPicker
extends Item {
    public static final String NBT_BOUND = "bound";

    public ItemPicker(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.func_175625_s(pos) instanceof TileMain) {
            ItemStack stack = player.func_184586_b(hand);
            DimPos.putPos(stack, pos, world);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        DimPos dp = DimPos.getPosStored(stack);
        if (dp != null && hand == Hand.MAIN_HAND && !world.field_72995_K) {
            ServerWorld serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.func_73046_m());
            if (serverTargetWorld == null) {
                StorageNetwork.LOGGER.error("Missing dimension key " + dp.getDimension());
                return ActionResultType.PASS;
            }
            TileEntity tile = serverTargetWorld.func_175625_s(dp.getBlockPos());
            if (tile instanceof TileMain) {
                int size;
                TileMain network = (TileMain)tile;
                BlockState bs = world.func_180495_p(pos);
                ItemStackMatcher matcher = new ItemStackMatcher(new ItemStack((IItemProvider)bs.func_177230_c()), false, false);
                ItemStack found = network.request(matcher, size = player.func_213453_ef() ? 1 : 64, false);
                if (!found.func_190926_b()) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.remote.found"), true);
                    if (!player.func_191521_c(found)) {
                        player.func_199701_a_(found);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.remote.notfound.item"), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.remote.notfound"), true);
            }
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        t.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
        if (stack.func_77942_o()) {
            DimPos dp = DimPos.getPosStored(stack);
            tooltip.add(dp.makeTooltip());
        }
    }
}

