/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.block.main.TileMain;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class UtilTileEntity {
    private static final Map<Item, String> modNamesForIds = new HashMap<Item, String>();
    public static final int MOUSE_BTN_LEFT = 0;
    public static final int MOUSE_BTN_RIGHT = 1;
    public static final int MOUSE_BTN_MIDDLE_CLICK = 2;

    public static void playSoundFromServer(ServerPlayerEntity entityIn, SoundEvent soundIn, float volume) {
        if (soundIn == null || entityIn == null) {
            return;
        }
        entityIn.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(soundIn, SoundCategory.PLAYERS, entityIn.field_70142_S, entityIn.field_70137_T, entityIn.field_70136_U, volume, 1.0f));
    }

    public static void chatMessage(PlayerEntity player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(message), player.func_110124_au());
        }
    }

    public static void statusMessage(PlayerEntity player, BlockState bs) {
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(bs.func_177230_c().func_235333_g_().getString()), true);
        }
    }

    public static void statusMessage(PlayerEntity player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(message), true);
        }
    }

    public static String lang(String message) {
        TranslationTextComponent t = new TranslationTextComponent(message);
        return t.func_150261_e();
    }

    public static TileMain getTileMainForConnectable(IConnectable connectable) {
        if (connectable == null || connectable.getMainPos() == null) {
            return null;
        }
        return connectable.getMainPos().getTileEntity(TileMain.class);
    }

    public static String getModNameForItem(Item theitem) {
        if (modNamesForIds.containsKey(theitem)) {
            return modNamesForIds.get(theitem);
        }
        String modId = theitem.getRegistryName().func_110624_b();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        modNamesForIds.put(theitem, lowercaseModId);
        return lowercaseModId;
    }
}

