/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileConnectable
extends BlockEntity {
    private final CapabilityConnectable connectable = new CapabilityConnectable();

    public TileConnectable(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void m_6596_() {
        super.m_6596_();
        this.connectable.setPos(new DimPos(this.f_58857_, this.f_58858_));
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("connectable")) {
            this.connectable.deserializeNBT(compound.m_128469_("connectable"));
        }
        super.m_142466_(compound);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128365_("connectable", (Tag)this.connectable.serializeNBT());
        return super.m_6945_(compound);
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag syncData = new CompoundTag();
        this.m_6945_(syncData);
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 0, syncData);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (StorageNetwork.CONFIG.doReloadOnChunk() && this.connectable != null && this.connectable.getMainPos() != null) {
            try {
                TileMain maybe = UtilTileEntity.getTileMainForConnectable(this.connectable);
                if (maybe != null) {
                    maybe.refreshNetwork();
                }
            }
            catch (Exception e) {
                StorageNetwork.LOGGER.info("Error on chunk unload " + e);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_CAPABILITY) {
            LazyOptional cap = LazyOptional.of(() -> this.connectable);
            return cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public DimPos getMain() {
        if (this.connectable == null) {
            return null;
        }
        return this.connectable.getMainPos();
    }
}

