/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.export;

import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.block.TileCableWithFacing;
import com.lothrazar.storagenetwork.block.cable.BlockCable;
import com.lothrazar.storagenetwork.block.cable.EnumConnectType;
import com.lothrazar.storagenetwork.block.cable.export.ContainerCableExportFilter;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableAutoIO;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileCableExport
extends TileCableWithFacing
implements MenuProvider {
    protected CapabilityConnectableAutoIO ioStorage = new CapabilityConnectableAutoIO(this, EnumStorageDirection.OUT);

    public TileCableExport(BlockPos pos, BlockState state) {
        super(SsnRegistry.EXPORTKABELTILE, pos, state);
        this.ioStorage.getFilter().isAllowList = true;
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerCableExportFilter(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public Component m_5446_() {
        return new TranslatableComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    @Override
    public void setDirection(Direction direction) {
        super.setDirection(direction);
        this.ioStorage.setInventoryFace(direction);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.ioStorage.deserializeNBT(compound.m_128469_("ioStorage"));
        this.ioStorage.upgrades.deserializeNBT(compound.m_128469_("upgrades"));
        this.ioStorage.getFilter().isAllowList = true;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        CompoundTag result = super.m_6945_(compound);
        result.m_128365_("ioStorage", (Tag)this.ioStorage.serializeNBT());
        result.m_128365_("upgrades", (Tag)this.ioStorage.upgrades.serializeNBT());
        return result;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_AUTO_IO) {
            LazyOptional cap = LazyOptional.of(() -> this.ioStorage);
            return cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    private void tick() {
        if (this.getDirection() == null) {
            this.findNewDirection();
            if (this.getDirection() != null) {
                BlockState newState = BlockCable.cleanBlockState(this.m_58900_());
                newState = (BlockState)newState.m_61124_((Property)BlockCable.FACING_TO_PROPERTY_MAP.get(this.getDirection()), (Comparable)((Object)EnumConnectType.CABLE));
                this.f_58857_.m_46597_(this.f_58858_, newState);
            }
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCableExport tile) {
        tile.tick();
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCableExport tile) {
        tile.tick();
    }
}

