/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableLink;
import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import com.lothrazar.storagenetwork.block.exchange.ExchangeItemStackHandler;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityConnectableLink
implements IConnectableLink,
INBTSerializable<CompoundTag> {
    public final IConnectable connectable;
    private boolean operationMustBeSmaller = true;
    private ItemStack operationStack = ItemStack.f_41583_;
    private int operationLimit = 0;
    private FilterItemStackHandler filters = new FilterItemStackHandler();
    private EnumStorageDirection filterDirection = EnumStorageDirection.BOTH;
    private Direction inventoryFace;
    private int priority;

    CapabilityConnectableLink() {
        this.connectable = new CapabilityConnectable();
        this.filters.setIsAllowlist(false);
    }

    public CapabilityConnectableLink(BlockEntity tile) {
        this.connectable = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
        this.filters.setIsAllowlist(false);
    }

    public FilterItemStackHandler getFilter() {
        return this.filters;
    }

    @Override
    public void setFilter(int value, ItemStack stack) {
        this.filters.setStackInSlot(value, stack);
        this.filters.getStacks().set(value, stack);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<ItemStack> getStoredStacks(boolean isFiltered) {
        if (this.inventoryFace == null || this.connectable.getPos() == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.m_41619_() || isFiltered && this.filters.isStackFiltered(stack)) continue;
            result.add(stack.m_41777_());
        }
        return result;
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        if (this.filterDirection == EnumStorageDirection.IN) {
            return stack;
        }
        if (this.filters.isStackFiltered(stack)) {
            return stack;
        }
        if (this.inventoryFace == null) {
            return stack;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        try {
            IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.m_122424_());
            if (itemHandler == null) {
                return stack;
            }
            return ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
        }
        catch (Exception e) {
            StorageNetwork.LOGGER.error("Insert stack error from other block ", (Throwable)e);
            return stack;
        }
    }

    @Override
    public ItemStack extractStack(IItemStackMatcher matcher, int size, boolean simulate) {
        if (size <= 0) {
            return ItemStack.f_41583_;
        }
        if (this.filterDirection == EnumStorageDirection.IN) {
            return ItemStack.f_41583_;
        }
        if (this.inventoryFace == null) {
            return ItemStack.f_41583_;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return ItemStack.f_41583_;
        }
        if (itemHandler instanceof ExchangeItemStackHandler) {
            return ItemStack.f_41583_;
        }
        ItemStack firstMatchedStack = ItemStack.f_41583_;
        int remaining = size;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.extractItem(slot, remaining, true);
            if (stack == null || stack.m_41619_() || this.filters.isStackFiltered(stack)) continue;
            if (firstMatchedStack.m_41619_()) {
                if (!matcher.match(stack)) continue;
                firstMatchedStack = stack.m_41777_();
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)firstMatchedStack, (ItemStack)stack)) continue;
            int toExtract = Math.min(stack.m_41613_(), remaining);
            ItemStack extractedStack = itemHandler.extractItem(slot, toExtract, simulate);
            if ((remaining -= extractedStack.m_41613_()) <= 0) break;
        }
        int extractCount = size - remaining;
        if (!firstMatchedStack.m_41619_() && extractCount > 0) {
            firstMatchedStack.m_41764_(extractCount);
        }
        return firstMatchedStack;
    }

    @Override
    public int getEmptySlots() {
        if (this.filterDirection == EnumStorageDirection.IN) {
            return 0;
        }
        if (this.inventoryFace == null) {
            return 0;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return 0;
        }
        int emptySlots = 0;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack != null && !stack.m_41619_()) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    @Override
    public void setPriority(int value) {
        this.priority = value;
    }

    @Override
    public EnumStorageDirection getSupportedTransferDirection() {
        return this.filterDirection;
    }

    public void setInventoryFace(Direction inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public CompoundTag serializeNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128405_("prio", this.priority);
        if (this.inventoryFace != null) {
            result.m_128359_("inventoryFace", this.inventoryFace.toString());
        }
        result.m_128359_("way", this.filterDirection.toString());
        CompoundTag operation = new CompoundTag();
        operation.m_128365_("stack", (Tag)this.operationStack.serializeNBT());
        operation.m_128379_("mustBeSmaller", this.operationMustBeSmaller);
        operation.m_128405_("limit", this.operationLimit);
        result.m_128365_("operation", (Tag)operation);
        CompoundTag filters = this.filters.serializeNBT();
        result.m_128365_("filters", (Tag)filters);
        return result;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.priority = nbt.m_128451_("prio");
        CompoundTag filters = nbt.m_128469_("filters");
        this.filters.deserializeNBT(filters);
        if (nbt.m_128441_("inventoryFace")) {
            this.inventoryFace = Direction.m_122402_((String)nbt.m_128461_("inventoryFace"));
        }
        try {
            this.filterDirection = EnumStorageDirection.valueOf(nbt.m_128461_("way"));
        }
        catch (Exception e) {
            this.filterDirection = EnumStorageDirection.BOTH;
        }
        CompoundTag operation = nbt.m_128469_("operation");
        this.operationStack = ItemStack.f_41583_;
        if (operation != null) {
            this.operationLimit = operation.m_128451_("limit");
            this.operationMustBeSmaller = operation.m_128471_("mustBeSmaller");
            if (operation.m_128425_("stack", 10)) {
                this.operationStack = ItemStack.m_41712_((CompoundTag)operation.m_128469_("stack"));
            }
        }
    }

    public static class Factory
    implements Callable<IConnectableLink> {
        @Override
        public IConnectableLink call() throws Exception {
            return new CapabilityConnectableLink();
        }
    }
}

