/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.block.cable.export.GuiCableExportFilter;
import com.lothrazar.storagenetwork.block.cable.inputfilter.GuiCableImportFilter;
import com.lothrazar.storagenetwork.block.cable.linkfilter.GuiCableFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class RefreshFilterClientMessage {
    private int size;
    private List<ItemStack> stacks;

    private RefreshFilterClientMessage() {
    }

    public RefreshFilterClientMessage(List<ItemStack> stacks) {
        this.stacks = stacks;
        this.size = stacks.size();
    }

    public static void handle(RefreshFilterClientMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            AbstractContainerScreen gui;
            if (Minecraft.m_91087_().f_91080_ instanceof GuiCableFilter) {
                gui = (GuiCableFilter)Minecraft.m_91087_().f_91080_;
                gui.setFilterItems(message.stacks);
            }
            if (Minecraft.m_91087_().f_91080_ instanceof GuiCableImportFilter) {
                gui = (GuiCableImportFilter)Minecraft.m_91087_().f_91080_;
                gui.setFilterItems(message.stacks);
            }
            if (Minecraft.m_91087_().f_91080_ instanceof GuiCableExportFilter) {
                gui = (GuiCableExportFilter)Minecraft.m_91087_().f_91080_;
                gui.setFilterItems(message.stacks);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static RefreshFilterClientMessage decode(FriendlyByteBuf buf) {
        RefreshFilterClientMessage message = new RefreshFilterClientMessage();
        message.size = buf.readInt();
        message.stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < message.size; ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)buf.m_130260_());
            stack.m_41764_(buf.readInt());
            message.stacks.add(stack);
        }
        return message;
    }

    public static void encode(RefreshFilterClientMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.size);
        for (ItemStack stack : msg.stacks) {
            buf.m_130079_(stack.serializeNBT());
            buf.writeInt(stack.m_41613_());
        }
    }
}

