/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.curios.api.CuriosApi;

public class UtilInventory {
    public static Triple<String, Integer, ItemStack> getCurioRemote(Player player, Item remote) {
        ItemStack temp;
        ImmutableTriple equipped;
        Triple stackFound = Triple.of((Object)"", (Object)-1, (Object)ItemStack.f_41583_);
        if (ModList.get().isLoaded("curios") && (equipped = (ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio(remote, (LivingEntity)player).orElse(null)) != null && UtilInventory.isRemote((ItemStack)equipped.right, remote)) {
            return Triple.of((Object)"curios", (Object)((Integer)equipped.middle), (Object)((ItemStack)equipped.right));
        }
        if (remote != SsnRegistry.COLLECTOR_REMOTE) {
            for (int i = 0; i < player.m_36327_().m_6643_(); ++i) {
                temp = player.m_36327_().m_8020_(i);
                if (!UtilInventory.isRemote(temp, remote)) continue;
                return Triple.of((Object)"ender", (Object)i, (Object)temp);
            }
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            temp = player.m_150109_().m_8020_(i);
            if (!UtilInventory.isRemote(temp, remote)) continue;
            return Triple.of((Object)"player", (Object)i, (Object)temp);
        }
        if (UtilInventory.isRemote(player.m_21206_(), remote)) {
            return Triple.of((Object)"offhand", (Object)-1, (Object)player.m_21206_());
        }
        if (UtilInventory.isRemote(player.m_21205_(), remote)) {
            return Triple.of((Object)"hand", (Object)-1, (Object)player.m_21205_());
        }
        return stackFound;
    }

    private static boolean isRemote(ItemStack temp, Item remote) {
        return temp.m_41720_() == remote;
    }

    public static String formatLargeNumber(int size) {
        if ((double)size < Math.pow(10.0, 3.0)) {
            return "" + size;
        }
        if ((double)size < Math.pow(10.0, 6.0)) {
            int rounded = Math.round((float)size / 1000.0f);
            return rounded + "K";
        }
        if ((double)size < Math.pow(10.0, 9.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 6.0));
            return rounded + "M";
        }
        if ((double)size < Math.pow(10.0, 12.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 9.0));
            return rounded + "B";
        }
        return "" + size;
    }

    public static int containsAtLeastHowManyNeeded(IItemHandler inv, ItemStack stack, int minimumCount) {
        int found = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
            found += inv.getStackInSlot(i).m_41613_();
        }
        if (found >= minimumCount) {
            return 0;
        }
        return minimumCount - found;
    }

    public static ItemStack extractItem(IItemHandler inv, ItemStackMatcher fil, int num, boolean simulate) {
        if (inv == null || fil == null) {
            return ItemStack.f_41583_;
        }
        int extracted = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack ex;
            ItemStack slot = inv.getStackInSlot(i);
            if (!fil.match(slot) || (ex = inv.extractItem(i, 1, simulate)).m_41619_()) continue;
            if (++extracted == num) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)slot, (int)num);
            }
            --i;
        }
        return ItemStack.f_41583_;
    }
}

