/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.block.ModelTomb;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderTomb
implements BlockEntityRenderer<TileEntityTomb> {
    private static final ResourceLocation SKELETON_HEAD = new ResourceLocation("minecraft", "textures/entity/skeleton/skeleton.png");
    private final Font font;
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy/MM/dd";

    public RenderTomb(BlockEntityRendererProvider.Context cx) {
        this.font = cx.m_173586_();
    }

    public void render(TileEntityTomb te, float partialTicks, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int light, int destroyStage) {
        int rotationIndex;
        float value;
        if (te == null) {
            return;
        }
        if (!te.hasOwner()) {
            return;
        }
        BlockState knownState = te.m_58904_().m_8055_(te.m_58899_());
        if (!(knownState.m_60734_() instanceof BlockTomb)) {
            return;
        }
        Direction facing = (Direction)knownState.m_61143_(BlockTomb.FACING);
        BlockTomb grave = (BlockTomb)knownState.m_60734_();
        ModelTomb graveModel = grave.getGraveType();
        this.renderHalloween(matrixStack, iRenderTypeBuffer, graveModel, facing, light, WorldHelper.isNight(te.m_58904_()));
        light = 0xF000F0;
        float modX = 0.5f;
        float modZ = 0.5f;
        float modY = switch (graveModel) {
            case ModelTomb.GRAVE_CROSS -> {
                value = 0.25f;
                yield 0.06375f;
            }
            case ModelTomb.GRAVE_NORMAL -> {
                value = 0.12625f;
                yield 0.5f;
            }
            default -> {
                value = 0.18875f;
                yield 0.4f;
            }
        };
        boolean isCross = graveModel == ModelTomb.GRAVE_CROSS;
        switch (facing) {
            case SOUTH: {
                rotationIndex = 0;
                if (isCross) {
                    modZ = 1.0f - value;
                    break;
                }
                modZ = value;
                break;
            }
            case WEST: {
                rotationIndex = -1;
                if (isCross) {
                    modX = value;
                    break;
                }
                modX = 1.0f - value;
                break;
            }
            case EAST: {
                rotationIndex = 1;
                if (isCross) {
                    modX = 1.0f - value;
                    break;
                }
                modX = value;
                break;
            }
            default: {
                rotationIndex = 2;
                modZ = isCross ? value : 1.0f - value;
            }
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)modX, (double)modY, (double)modZ);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        if (isCross) {
            switch (facing) {
                case SOUTH: {
                    matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                    break;
                }
                case WEST: {
                    matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                    break;
                }
                case EAST: {
                    matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
                    break;
                }
                default: {
                    matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                }
            }
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f * (float)rotationIndex));
        Font fontRender = this.font;
        int textColor = -1;
        this.showString(ChatFormatting.BOLD + MessageType.MESSAGE_RIP.getTranslation(new Object[0]), matrixStack, iRenderTypeBuffer, fontRender, 0, textColor, 0.007f, light);
        this.showString(ChatFormatting.BOLD + te.getOwnerName(), matrixStack, iRenderTypeBuffer, fontRender, 11, textColor, 0.005f, light);
        float scaleForDate = 0.004f;
        long days = te.timer / 24000;
        String dateString = MessageType.MESSAGE_DAY.getTranslation(days);
        this.showString(ChatFormatting.BOLD + dateString, matrixStack, iRenderTypeBuffer, fontRender, 20, textColor, scaleForDate, light);
        Date date = new Date(te.getOwnerDeathTime());
        String fdateString = new SimpleDateFormat(DATE_FORMAT).format(date);
        String timeString = new SimpleDateFormat(TIME_FORMAT).format(date);
        this.showString(ChatFormatting.BOLD + fdateString, matrixStack, iRenderTypeBuffer, fontRender, 36, textColor, scaleForDate, light);
        this.showString(ChatFormatting.BOLD + timeString, matrixStack, iRenderTypeBuffer, fontRender, 46, textColor, scaleForDate, light);
        matrixStack.m_85849_();
    }

    private void showString(String content, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, Font fontRenderer, int posY, int color, float scale, int light) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, scale);
        fontRenderer.m_92811_(content, (float)(-fontRenderer.m_92895_(content) / 2), (float)(posY - 30), color, false, matrixStack.m_85850_().m_85861_(), iRenderTypeBuffer, false, 0, light);
        matrixStack.m_85849_();
    }

    private void renderHalloween(PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, ModelTomb graveModel, Direction facing, int light, boolean isNight) {
        RenderSystem.m_69464_();
        float decoX = 0.5f;
        float decoY = 0.07f;
        float decoZ = 0.5f;
        switch (graveModel) {
            case GRAVE_NORMAL: {
                decoY += 0.35f;
                break;
            }
            case GRAVE_CROSS: {
                if (facing == Direction.SOUTH) {
                    decoX -= 0.2f;
                    break;
                }
                if (facing == Direction.WEST) {
                    decoZ -= 0.2f;
                    break;
                }
                if (facing == Direction.EAST) {
                    decoZ += 0.2f;
                    break;
                }
                decoX += 0.2f;
                break;
            }
            default: {
                decoY += 0.1f;
            }
        }
        Minecraft.m_91087_().f_90987_.m_174784_(SKELETON_HEAD);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)decoX, (double)decoY, (double)decoZ);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(facing.m_122435_() + (float)(facing == Direction.SOUTH || facing == Direction.NORTH ? 180 : 0)));
        if (graveModel == ModelTomb.GRAVE_NORMAL || graveModel == ModelTomb.GRAVE_SIMPLE) {
            matrixStack.m_85841_(0.2f, 0.2f, 0.2f);
            ItemStack stack = new ItemStack((ItemLike)(isNight ? Blocks.f_50144_ : Blocks.f_50133_));
            Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemTransforms.TransformType.NONE, false, matrixStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0));
        } else {
            matrixStack.m_85841_(0.3f, 0.3f, 0.3f);
        }
        matrixStack.m_85849_();
    }
}

