/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class PlayerTombRecords {
    UUID playerId;
    public List<CompoundTag> playerGraves = new ArrayList<CompoundTag>();

    public PlayerTombRecords(UUID id, CompoundTag first) {
        this.playerId = id;
        this.playerGraves.add(first);
    }

    public PlayerTombRecords() {
    }

    public CompoundTag getGrave(int index) {
        if (index >= this.playerGraves.size()) {
            return null;
        }
        return this.playerGraves.get(index);
    }

    public void read(CompoundTag data, UUID playerId) {
        this.playerId = playerId;
        if (data.m_128441_("simpletomb")) {
            ListTag glist = data.m_128437_("simpletomb", 10);
            for (int i = 0; i < glist.size(); ++i) {
                this.playerGraves.add(glist.m_128728_(i));
            }
        }
    }

    public CompoundTag write() {
        CompoundTag data = new CompoundTag();
        ListTag glist = new ListTag();
        for (CompoundTag g : this.playerGraves) {
            glist.add((Object)g);
        }
        data.m_128365_("simpletomb", (Tag)glist);
        return data;
    }

    public static BlockPos getPos(CompoundTag grave) {
        return NbtUtils.m_129239_((CompoundTag)grave.m_128469_("pos"));
    }

    public static String getDim(CompoundTag grave) {
        return grave.m_128461_("dimension");
    }

    public static List<ItemStack> getDrops(CompoundTag grave) {
        ListTag drops = grave.m_128437_("drops", 10);
        ArrayList<ItemStack> done = new ArrayList<ItemStack>();
        for (int i = 0; i < drops.size(); ++i) {
            done.add(ItemStack.m_41712_((CompoundTag)drops.m_128728_(i)));
        }
        return done;
    }

    public void deleteAll() {
        this.playerGraves = new ArrayList<CompoundTag>();
    }

    public String getCoordinatesAsString(BlockPos pos) {
        return pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_();
    }

    public String toDisplayString(int i) {
        CompoundTag gd = this.getGrave(i);
        return String.format("[%d] (%s) (%s) {%d}", i, PlayerTombRecords.getDim(gd), this.getCoordinatesAsString(PlayerTombRecords.getPos(gd)), PlayerTombRecords.getDrops(gd).size());
    }
}

