/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.client.LineRenderType;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.particle.ParticleGraveSmoke;
import com.lothrazar.simpletomb.particle.ParticleGraveSoul;
import com.lothrazar.simpletomb.particle.ParticleRotatingSmoke;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simpletomb", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        ParticleEngine r = Minecraft.m_91087_().f_91061_;
        r.m_107378_((ParticleType)TombRegistry.GRAVE_SMOKE, ParticleGraveSmoke.Factory::new);
        r.m_107378_((ParticleType)TombRegistry.ROTATING_SMOKE, ParticleRotatingSmoke.Factory::new);
        r.m_107378_((ParticleType)TombRegistry.SOUL, ParticleGraveSoul.Factory::new);
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        ItemStack stack;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.f_19853_ != null && (stack = player.m_21205_()).m_41720_() == TombRegistry.GRAVE_KEY) {
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            LocationBlockPos location = TombRegistry.GRAVE_KEY.getTombPos(stack);
            if (location != null && !location.isOrigin() && location.dim.equalsIgnoreCase(WorldHelper.dimensionToString(player.f_19853_)) && player.f_19853_.m_46739_(location.toBlockPos())) {
                PoseStack poseStack = event.getMatrixStack();
                poseStack.m_85836_();
                ClientEvents.createBox(bufferSource, poseStack, location.x, location.y, location.z, 1.0f);
                poseStack.m_85849_();
            }
        }
    }

    private static void createBox(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, float x, float y, float z, float offset) {
        long c = System.currentTimeMillis() / 15L % 360L;
        float[] color = WorldHelper.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPosition = mc.f_91063_.m_109153_().m_90583_();
        Vec3 vec = new Vec3((double)x, (double)y, (double)z).m_82546_(cameraPosition);
        if (vec.m_82554_(Vec3.f_82478_) > 200.0) {
            vec = vec.m_82541_().m_82490_(200.0);
            x = (float)((double)x + vec.f_82479_);
            y = (float)((double)y + vec.f_82480_);
            z = (float)((double)z + vec.f_82481_);
        }
        RenderSystem.m_69465_();
        RenderType renderType = LineRenderType.tombLinesType();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        poseStack.m_85837_(-cameraPosition.f_82479_, -cameraPosition.f_82480_, -cameraPosition.f_82481_);
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        vertexConsumer.m_85982_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_85982_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        bufferSource.m_109912_(renderType);
        RenderSystem.m_69482_();
    }
}

