/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.data.DeathHelper;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.data.PlayerTombRecords;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PlayerTombEvents {
    public Map<UUID, PlayerTombRecords> grv = new HashMap<UUID, PlayerTombRecords>();
    private static final String TOMB_FILE_EXT = ".mctomb";
    private static final String TB_SOULBOUND_STACKS = "tb_soulbound_stacks";

    public PlayerTombRecords findGrave(UUID id) {
        if (this.grv.containsKey(id)) {
            return this.grv.get(id);
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLogged(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getPlayer())) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            assert (player.m_20194_() != null);
            CompoundTag playerData = player.getPersistentData();
            if (playerData.m_128441_("PlayerPersisted")) {
                CompoundTag persistantData = playerData.m_128469_("PlayerPersisted");
            } else {
                CompoundTag persistantData = new CompoundTag();
                playerData.m_128365_("PlayerPersisted", (Tag)persistantData);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> event.getWorld().m_8055_(blockPos).m_60734_() instanceof BlockTomb);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (EntityHelper.isValidPlayerMP((Entity)player) && !player.m_5833_()) {
            CompoundTag persistentTag = EntityHelper.getPersistentTag(player);
            ListTag stackList = persistentTag.m_128437_(TB_SOULBOUND_STACKS, 10);
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)stackList.m_128728_(i));
                if (stack.m_41619_()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            }
            persistentTag.m_128473_(TB_SOULBOUND_STACKS);
            player.f_36095_.m_38946_();
        }
    }

    private void storeSoulboundsOnBody(Player player, List<ItemStack> keys) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag(player);
        ListTag stackList = new ListTag();
        persistentTag.m_128365_(TB_SOULBOUND_STACKS, (Tag)stackList);
        for (ItemStack key : keys) {
            stackList.add((Object)key.serializeNBT());
        }
        keys.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerDrops(LivingDropsEvent event) {
        if (!((Boolean)ConfigTomb.TOMBENABLED.get()).booleanValue()) {
            return;
        }
        if (!EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) || WorldHelper.isRuleKeepInventory((Player)event.getEntityLiving())) {
            return;
        }
        this.saveBackup(event);
        this.placeTombstone(event);
    }

    @SubscribeEvent
    public void onSaveFile(PlayerEvent.SaveToFile event) {
        Player player = event.getPlayer();
        File mctomb = new File(event.getPlayerDirectory(), player.m_142081_() + TOMB_FILE_EXT);
        if (this.grv.containsKey(player.m_142081_())) {
            PlayerTombRecords dataToSave = this.grv.get(player.m_142081_());
            CompoundTag data = dataToSave.write();
            try {
                FileOutputStream fileoutputstream = new FileOutputStream(mctomb);
                NbtIo.m_128947_((CompoundTag)data, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (IOException e) {
                ModTomb.LOGGER.error("IO", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onLoadFile(PlayerEvent.LoadFromFile event) {
        Player player = event.getPlayer();
        File mctomb = new File(event.getPlayerDirectory(), player.m_142081_() + TOMB_FILE_EXT);
        if (mctomb.exists()) {
            try {
                FileInputStream fileinputstream = new FileInputStream(mctomb);
                CompoundTag data = NbtIo.m_128939_((InputStream)fileinputstream);
                fileinputstream.close();
                PlayerTombRecords dataLoaded = new PlayerTombRecords();
                dataLoaded.read(data, player.m_142081_());
                if (this.grv.containsKey(player.m_142081_())) {
                    this.grv.put(player.m_142081_(), dataLoaded);
                } else {
                    this.grv.put(player.m_142081_(), dataLoaded);
                }
            }
            catch (Exception e) {
                ModTomb.LOGGER.error("IO", (Throwable)e);
            }
        }
    }

    private void saveBackup(LivingDropsEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntityLiving();
        Iterator it = event.getDrops().iterator();
        ListTag drops = new ListTag();
        boolean isEmpty = true;
        CompoundTag tombstoneTag = new CompoundTag();
        while (it.hasNext()) {
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.m_32055_().m_41619_()) continue;
            ItemStack stack = entityItem.m_32055_();
            drops.add((Object)stack.m_41739_(new CompoundTag()));
            if (stack.m_41720_() == TombRegistry.GRAVE_KEY) continue;
            isEmpty = false;
        }
        if (!isEmpty) {
            tombstoneTag.m_128356_("timestamp", System.currentTimeMillis());
            tombstoneTag.m_128365_("drops", (Tag)drops);
            tombstoneTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)player.m_142538_()));
            tombstoneTag.m_128359_("dimension", player.f_19853_.m_46472_().m_135782_().toString());
            UUID pid = player.m_142081_();
            tombstoneTag.m_128359_("playerid", pid.toString());
            tombstoneTag.m_128359_("playername", player.m_5446_().getString());
            if (this.grv.containsKey(pid)) {
                this.grv.get((Object)pid).playerGraves.add(tombstoneTag);
            } else {
                this.grv.put(pid, new PlayerTombRecords(pid, tombstoneTag));
            }
        }
    }

    private void placeTombstone(LivingDropsEvent event) {
        boolean hasDrop;
        ServerPlayer player = (ServerPlayer)event.getEntityLiving();
        ServerLevel world = player.m_9236_();
        Iterator it = event.getDrops().iterator();
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        while (it.hasNext()) {
            ItemStack stack;
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.m_32055_().m_41619_() || (stack = entityItem.m_32055_()).m_41720_() != TombRegistry.GRAVE_KEY) continue;
            keys.add(stack.m_41777_());
            it.remove();
        }
        List<ItemEntity> itemsPickedUpFromGround = this.pickupFromGround((Player)player, keys);
        this.storeSoulboundsOnBody((Player)player, keys);
        boolean bl = hasDrop = event.getDrops().size() > 0 || itemsPickedUpFromGround.size() > 0;
        if (!hasDrop) {
            MessageType.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
            return;
        }
        BlockPos initPos = WorldHelper.getInitialPos((Level)world, new BlockPos((Vec3i)player.m_142538_()));
        LocationBlockPos spawnPos = WorldHelper.findGraveSpawn((Player)player, initPos);
        if (spawnPos == null || spawnPos.toBlockPos() == null) {
            MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
            ModTomb.LOGGER.log(org.apache.logging.log4j.Level.INFO, MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.getTranslation(new Object[0]));
            return;
        }
        Direction facing = player.m_6350_().m_122424_();
        BlockState state = PlayerTombEvents.getRandomGrave(world, facing);
        boolean wasPlaced = WorldHelper.placeGrave((Level)world, spawnPos.toBlockPos(), state);
        if (!wasPlaced) {
            PlayerTombEvents.sendFailMessage(player);
            return;
        }
        BlockEntity tile = world.m_7702_(spawnPos.toBlockPos());
        IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        if (!(tile instanceof TileEntityTomb) || itemHandler == null) {
            PlayerTombEvents.sendFailMessage(player);
            return;
        }
        TileEntityTomb grave = (TileEntityTomb)tile;
        grave.initTombstoneOwner((Player)player);
        if (((Boolean)ConfigTomb.KEYGIVEN.get()).booleanValue()) {
            ItemStack key = new ItemStack((ItemLike)TombRegistry.GRAVE_KEY);
            TombRegistry.GRAVE_KEY.setTombPos(key, spawnPos);
            PlayerTombEvents.setKeyName(player, key);
            keys.add(key);
        }
        this.storeSoulboundsOnBody((Player)player, keys);
        for (ItemEntity entityItem : event.getDrops()) {
            if (entityItem.m_32055_().m_41619_()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.m_32055_().m_41777_(), (boolean)false);
            entityItem.m_32045_(ItemStack.f_41583_);
        }
        for (ItemEntity entityItem : itemsPickedUpFromGround) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.m_32055_(), (boolean)false);
            entityItem.m_32045_(ItemStack.f_41583_);
        }
        world.m_7260_(spawnPos.toBlockPos(), state, state, 2);
        DeathHelper.INSTANCE.putLastGrave((Player)player, spawnPos);
        if (((Boolean)ConfigTomb.TOMBLOG.get()).booleanValue()) {
            ModTomb.LOGGER.info(MessageType.MESSAGE_NEW_GRAVE.getTranslation(new Object[0]) + String.format("(%d, %d, %d) " + spawnPos.dim, spawnPos.x, spawnPos.y, spawnPos.z));
        }
        if (((Boolean)ConfigTomb.TOMBCHAT.get()).booleanValue()) {
            MessageType.MESSAGE_NEW_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
            MessageType.MESSAGE_JOURNEYMAP.sendSpecialMessage((Player)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
        }
    }

    public static void sendFailMessage(ServerPlayer player) {
        MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
        ModTomb.LOGGER.log(org.apache.logging.log4j.Level.INFO, MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslation(new Object[0]));
    }

    public static void setKeyName(ServerPlayer player, ItemStack key) {
        PlayerTombEvents.putKeyName(player.m_7755_().getString(), key);
    }

    public static void putKeyName(String player, ItemStack key) {
        if (((Boolean)ConfigTomb.KEYNAMED.get()).booleanValue()) {
            TranslatableComponent text = new TranslatableComponent(player);
            text.m_7220_((Component)new TranslatableComponent(" "));
            text.m_7220_(key.m_41786_());
            text.m_130940_(ChatFormatting.GOLD);
            key.m_41714_((Component)text);
        }
    }

    static BlockState getRandomGrave(ServerLevel world, Direction facing) {
        BlockTomb[] graves = new BlockTomb[]{TombRegistry.GRAVE_SIMPLE, TombRegistry.GRAVE_NORMAL, TombRegistry.GRAVE_CROSS, TombRegistry.TOMBSTONE};
        BlockState state = graves[world.f_46441_.nextInt(graves.length)].m_49966_();
        state = (BlockState)state.m_61124_(BlockTomb.FACING, (Comparable)facing);
        state = (BlockState)state.m_61124_((Property)BlockTomb.MODEL_TEXTURE, (Comparable)Integer.valueOf(world.f_46441_.nextInt(2)));
        return state;
    }

    private List<ItemEntity> pickupFromGround(Player player, ArrayList<ItemStack> keys) {
        double range = ((Integer)ConfigTomb.TOMBEXTRAITEMS.get()).intValue();
        if (range == 0.0) {
            return new ArrayList<ItemEntity>();
        }
        int posX = player.m_142538_().m_123341_();
        int posY = player.m_142538_().m_123342_();
        int posZ = player.m_142538_().m_123343_();
        return player.f_19853_.m_45976_(ItemEntity.class, new AABB((double)posX - range, (double)posY - range, (double)posZ - range, (double)posX + range, (double)posY + range, (double)posZ + range));
    }
}

