/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.data.LocationBlockPos;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class NBTHelper {
    private static CompoundTag getOrCreateTag(ItemStack stack) {
        return stack.m_41784_();
    }

    private static void setBlockPos(CompoundTag tag, String keyName, BlockPos keyValue) {
        tag.m_128405_(keyName + "X", keyValue.m_123341_());
        tag.m_128405_(keyName + "Y", keyValue.m_123342_());
        tag.m_128405_(keyName + "Z", keyValue.m_123343_());
    }

    private static BlockPos getBlockPos(@Nullable CompoundTag tag, String keyName) {
        return tag != null && tag.m_128441_(keyName + "X") && tag.m_128441_(keyName + "Y") && tag.m_128441_(keyName + "Z") ? new BlockPos(tag.m_128451_(keyName + "X"), tag.m_128451_(keyName + "Y"), tag.m_128451_(keyName + "Z")) : BlockPos.f_121853_;
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, LocationBlockPos location) {
        NBTHelper.setLocation(NBTHelper.getOrCreateTag(stack), keyName, location);
        return stack;
    }

    private static CompoundTag setLocation(CompoundTag tag, String keyName, LocationBlockPos location) {
        NBTHelper.setBlockPos(tag, keyName, location.toBlockPos());
        tag.m_128359_(keyName + "D", location.dim);
        return tag;
    }

    public static LocationBlockPos getLocation(ItemStack stack, String keyName) {
        return NBTHelper.getLocation(NBTHelper.getOrCreateTag(stack), keyName);
    }

    private static LocationBlockPos getLocation(@Nullable CompoundTag tag, String keyName) {
        BlockPos pos;
        if (tag != null && tag.m_128441_(keyName + "D") && !(pos = NBTHelper.getBlockPos(tag, keyName)).equals((Object)BlockPos.f_121853_)) {
            return new LocationBlockPos(pos, tag.m_128461_(keyName + "D"));
        }
        return LocationBlockPos.ORIGIN;
    }
}

